/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.entities;

import com.mrbysco.instrumentalmobs.entities.IInstrumentalMobs;
import com.mrbysco.instrumentalmobs.entities.projectiles.EntitySoundWaves;
import com.mrbysco.instrumentalmobs.init.InstrumentalRegistry;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class MicrophoneGhastEntity
extends Ghast
implements IInstrumentalMobs {
    private static final EntityDataAccessor<Boolean> SINGING = SynchedEntityData.m_135353_(MicrophoneGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public MicrophoneGhastEntity(EntityType<? extends MicrophoneGhastEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)InstrumentalRegistry.microphone.get()));
        this.m_21409_(EquipmentSlot.HEAD, this.getDropChance());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new RandomFlyGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new LookAroundGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new VoiceAttackGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, p_213812_1_ -> Math.abs(p_213812_1_.m_20186_() - this.m_20186_()) <= 4.0));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(SINGING, (Object)false);
    }

    public void setSinging(boolean isSinging) {
        this.m_20088_().m_135381_(SINGING, (Object)isSinging);
    }

    public boolean isSinging() {
        return (Boolean)this.m_20088_().m_135370_(SINGING);
    }

    public static boolean canSpawnHere(EntityType<MicrophoneGhastEntity> p_223368_0_, LevelAccessor p_223368_1_, MobSpawnType reason, BlockPos p_223368_3_, Random p_223368_4_) {
        return p_223368_1_.m_46791_() != Difficulty.PEACEFUL && p_223368_4_.nextInt(20) == 0 && MicrophoneGhastEntity.m_21400_(p_223368_0_, (LevelAccessor)p_223368_1_, (MobSpawnType)reason, (BlockPos)p_223368_3_, (Random)p_223368_4_);
    }

    static class RandomFlyGoal
    extends Goal {
        private final MicrophoneGhastEntity parentEntity;

        public RandomFlyGoal(MicrophoneGhastEntity ghast) {
            this.parentEntity = ghast;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl movementcontroller = this.parentEntity.m_21566_();
            if (!movementcontroller.m_24995_()) {
                return true;
            }
            double d0 = movementcontroller.m_25000_() - this.parentEntity.m_20185_();
            double d3 = d0 * d0 + (d1 = movementcontroller.m_25001_() - this.parentEntity.m_20186_()) * d1 + (d2 = movementcontroller.m_25002_() - this.parentEntity.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            Random random = this.parentEntity.m_21187_();
            double d0 = this.parentEntity.m_20185_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.m_20186_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.m_20189_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.m_21566_().m_6849_(d0, d1, d2, 1.0);
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final MicrophoneGhastEntity ghast;

        public LookAroundGoal(MicrophoneGhastEntity ghast) {
            this.ghast = ghast;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.ghast.m_5448_() == null) {
                Vec3 vec3 = this.ghast.m_20184_();
                this.ghast.m_146922_(-((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 57.295776f);
                this.ghast.f_20883_ = this.ghast.m_146908_();
            } else {
                LivingEntity livingentity = this.ghast.m_5448_();
                double d0 = 64.0;
                if (livingentity.m_20280_((Entity)this.ghast) < 4096.0) {
                    double d1 = livingentity.m_20185_() - this.ghast.m_20185_();
                    double d2 = livingentity.m_20189_() - this.ghast.m_20189_();
                    this.ghast.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
                    this.ghast.f_20883_ = this.ghast.m_146908_();
                }
            }
        }
    }

    static class VoiceAttackGoal
    extends Goal {
        private final MicrophoneGhastEntity parentEntity;
        public int attackTimer;

        public VoiceAttackGoal(MicrophoneGhastEntity ghast) {
            this.parentEntity = ghast;
        }

        public boolean m_8036_() {
            return this.parentEntity.m_5448_() != null;
        }

        public void m_8056_() {
            this.attackTimer = 0;
            this.parentEntity.setSinging(true);
        }

        public void m_8041_() {
            this.parentEntity.m_32758_(false);
            this.parentEntity.setSinging(false);
        }

        public void m_8037_() {
            LivingEntity livingentity = this.parentEntity.m_5448_();
            double d0 = 64.0;
            if (livingentity.m_20280_((Entity)this.parentEntity) < 4096.0 && this.parentEntity.m_142582_((Entity)livingentity)) {
                Level world = this.parentEntity.f_19853_;
                ++this.attackTimer;
                if (this.attackTimer == 10 && !this.parentEntity.m_20067_()) {
                    world.m_5898_((Player)null, 1015, this.parentEntity.m_142538_(), 0);
                }
                if (this.attackTimer == 20) {
                    double d1 = 4.0;
                    Vec3 vector3d = this.parentEntity.m_20252_(1.0f);
                    double d2 = livingentity.m_20185_() - (this.parentEntity.m_20185_() + vector3d.f_82479_ * 4.0);
                    double d3 = livingentity.m_20227_(0.5) - (0.5 + this.parentEntity.m_20227_(0.5));
                    double d4 = livingentity.m_20189_() - (this.parentEntity.m_20189_() + vector3d.f_82481_ * 4.0);
                    if (!this.parentEntity.m_20067_()) {
                        world.m_5898_((Player)null, 1016, this.parentEntity.m_142538_(), 0);
                    }
                    EntitySoundWaves entitysoundwave = new EntitySoundWaves(world, (LivingEntity)this.parentEntity, d2, d3, d4);
                    entitysoundwave.m_6034_(this.parentEntity.m_20185_() + vector3d.f_82479_ * 4.0, this.parentEntity.m_20227_(0.5) + 0.5, entitysoundwave.m_20189_() + vector3d.f_82481_ * 4.0);
                    world.m_7967_((Entity)entitysoundwave);
                    this.attackTimer = -40;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            this.parentEntity.m_32758_(this.attackTimer > 10);
        }
    }
}

