/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.entities;

import com.mrbysco.instrumentalmobs.entities.IInstrumentalMobs;
import com.mrbysco.instrumentalmobs.entities.goals.InstrumentAttackGoal;
import com.mrbysco.instrumentalmobs.init.InstrumentalRegistry;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TubaEndermanEntity
extends EnderMan
implements IInstrumentalMobs {
    private final InstrumentAttackGoal playOnCollideGoal = new InstrumentAttackGoal((PathfinderMob)this, 1.0, false, () -> (SoundEvent)InstrumentalRegistry.tuba_sound.get());

    public TubaEndermanEntity(EntityType<? extends TubaEndermanEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)InstrumentalRegistry.tuba.get()));
        this.m_21409_(EquipmentSlot.MAINHAND, this.getDropChance());
        this.setCombatTask();
    }

    private void setCombatTask() {
        if (this.f_19853_ != null && !this.f_19853_.f_46443_) {
            this.f_21345_.m_25363_((Goal)this.playOnCollideGoal);
            ItemStack itemstack = this.m_21205_();
            if (itemstack.m_41720_() == InstrumentalRegistry.tuba.get()) {
                this.f_21345_.m_25352_(7, (Goal)this.playOnCollideGoal);
            }
        }
    }

    public void m_32528_() {
        if (this.f_19797_ >= this.f_32476_ + 400) {
            this.f_32476_ = this.f_19797_;
            if (!this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), SoundEvents.f_11851_, this.m_5720_(), 2.5f, 1.0f, false);
                if ((double)this.m_21187_().nextFloat() < 0.3) {
                    this.f_19853_.m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), (SoundEvent)InstrumentalRegistry.tuba_sound.get(), this.m_5720_(), 2.5f, 1.0f, false);
                }
            }
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new StareGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new LookForPlayerGOal(this, arg_0 -> ((TubaEndermanEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    private boolean isLookingAtMe(Player player) {
        ItemStack itemstack = (ItemStack)player.m_150109_().f_35975_.get(3);
        if (itemstack.isEnderMask(player, (EnderMan)this)) {
            return false;
        }
        Vec3 vec3 = player.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(this.m_20185_() - player.m_20185_(), this.m_20188_() - player.m_20188_(), this.m_20189_() - player.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 0.025 / d0 ? player.m_142582_((Entity)this) : false;
    }

    static class StareGoal
    extends Goal {
        private final TubaEndermanEntity enderman;
        private LivingEntity targetPlayer;

        public StareGoal(TubaEndermanEntity endermanIn) {
            this.enderman = endermanIn;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.targetPlayer = this.enderman.m_5448_();
            if (!(this.targetPlayer instanceof Player)) {
                return false;
            }
            double d0 = this.targetPlayer.m_20280_((Entity)this.enderman);
            return d0 > 256.0 ? false : this.enderman.isLookingAtMe((Player)this.targetPlayer);
        }

        public void m_8056_() {
            this.enderman.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.enderman.m_21563_().m_24946_(this.targetPlayer.m_20185_(), this.targetPlayer.m_20188_(), this.targetPlayer.m_20189_());
        }
    }

    static class LookForPlayerGOal
    extends NearestAttackableTargetGoal<Player> {
        private final TubaEndermanEntity enderman;
        private Player pendingTarget;
        private int aggroTime;
        private int teleportTime;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.m_148352_().m_148355_();

        public LookForPlayerGOal(TubaEndermanEntity tubaEnderman, @Nullable Predicate<LivingEntity> livingEntityPredicate) {
            super((Mob)tubaEnderman, Player.class, 10, false, false, livingEntityPredicate);
            this.enderman = tubaEnderman;
            this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(entity -> tubaEnderman.isLookingAtMe((Player)entity));
        }

        public boolean m_8036_() {
            this.pendingTarget = this.enderman.f_19853_.m_45946_(this.startAggroTargetConditions, (LivingEntity)this.enderman);
            return this.pendingTarget != null;
        }

        public void m_8056_() {
            this.aggroTime = 5;
            this.teleportTime = 0;
            this.enderman.m_32533_();
        }

        public void m_8041_() {
            this.pendingTarget = null;
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.pendingTarget != null) {
                if (!this.enderman.isLookingAtMe(this.pendingTarget)) {
                    return false;
                }
                this.enderman.m_21391_((Entity)this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            return this.f_26050_ != null && this.continueAggroTargetConditions.m_26885_((LivingEntity)this.enderman, this.f_26050_) ? true : super.m_8045_();
        }

        public void m_8037_() {
            if (this.enderman.m_5448_() == null) {
                super.m_26070_((LivingEntity)null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.f_26050_ = this.pendingTarget;
                    this.pendingTarget = null;
                    super.m_8056_();
                }
            } else {
                if (this.f_26050_ != null && !this.enderman.m_20159_()) {
                    if (this.enderman.isLookingAtMe((Player)this.f_26050_)) {
                        if (this.f_26050_.m_20280_((Entity)this.enderman) < 16.0) {
                            this.enderman.m_32529_();
                        }
                        this.teleportTime = 0;
                    } else if (this.f_26050_.m_20280_((Entity)this.enderman) > 256.0 && this.teleportTime++ >= 30 && this.enderman.m_32500_((Entity)this.f_26050_)) {
                        this.teleportTime = 0;
                    }
                }
                super.m_8037_();
            }
        }
    }
}

