/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.entities.projectiles;

import com.mrbysco.instrumentalmobs.Reference;
import com.mrbysco.instrumentalmobs.config.InstrumentalConfig;
import com.mrbysco.instrumentalmobs.init.InstrumentalRegistry;
import com.mrbysco.instrumentalmobs.utils.InstrumentHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fmllegacy.network.FMLPlayMessages;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class EntitySoundWaves
extends AbstractHurtingProjectile
implements ItemSupplier {
    private SoundEvent sound = SoundEvents.f_11922_;

    public EntitySoundWaves(EntityType<? extends EntitySoundWaves> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntitySoundWaves(Level worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super((EntityType)InstrumentalRegistry.SOUND_WAVE.get(), x, y, z, accelX, accelY, accelZ, worldIn);
    }

    public EntitySoundWaves(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType)InstrumentalRegistry.SOUND_WAVE.get(), shooter, accelX, accelY, accelZ, worldIn);
    }

    public EntitySoundWaves(Level worldIn, LivingEntity shooter, SoundEvent theSound) {
        super((EntityType)InstrumentalRegistry.SOUND_WAVE.get(), shooter, 1.0, 1.0, 1.0, worldIn);
        this.sound = theSound;
    }

    public EntitySoundWaves(FMLPlayMessages.SpawnEntity spawnEntity, Level worldIn) {
        this((EntityType<? extends EntitySoundWaves>)((EntityType)InstrumentalRegistry.SOUND_WAVE.get()), worldIn);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.f_19853_.f_46443_) {
            this.soundExplosion();
            this.m_6089_();
        }
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity = result.m_82443_();
        if (entity instanceof Player && this.m_37282_() instanceof Player) {
            Player collidingPlayer;
            Player playerIn = (Player)this.m_37282_();
            if (playerIn.m_7099_(collidingPlayer = (Player)entity) && this.f_19853_.f_46441_.nextInt(10) <= 2) {
                collidingPlayer.m_6469_(Reference.causeSoundDamage((Entity)this), 1.0f);
            }
        } else if (this.m_37282_() instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)this.m_37282_();
            entity.m_6469_(Reference.causeSoundDamage((Entity)this), 6.0f);
            this.m_19970_(livingEntity, entity);
        }
    }

    public void soundExplosion() {
        this.f_19853_.m_5594_(null, this.m_142538_(), this.sound, this.m_5720_(), 1.0f, this.f_19853_.f_46441_.nextFloat() * 0.1f + 0.9f);
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        if (((Boolean)InstrumentalConfig.COMMON.mobsReact.get()).booleanValue() && this.m_37282_() instanceof LivingEntity) {
            InstrumentHelper.instrumentDamage(this.f_19853_, (LivingEntity)this.m_37282_(), this.m_142469_().m_82400_(((Double)InstrumentalConfig.COMMON.instrumentRange.get()).doubleValue()));
        }
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vec3 = new Vec3(x, y, z).m_82541_().m_82520_(this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy).m_82490_((double)velocity);
        this.m_20256_(vec3);
        double d0 = vec3.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
    }

    protected void m_8097_() {
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)InstrumentalRegistry.microphone.get());
    }
}

