/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.init;

import com.mrbysco.instrumentalmobs.entities.CymbalHuskEntity;
import com.mrbysco.instrumentalmobs.entities.MicrophoneGhastEntity;
import com.mrbysco.instrumentalmobs.init.InstrumentalRegistry;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="instrumentalmobs")
public class InstrumentalEntities {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void addSpawn(BiomeLoadingEvent event) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(event.getName());
        if (biome != null) {
            MobSpawnSettings info = biome.m_47518_();
            List spawns = event.getSpawns().getSpawner(MobCategory.MONSTER);
            for (MobSpawnSettings.SpawnerData entry : info.m_151798_(MobCategory.MONSTER).m_146338_()) {
                InstrumentalEntities.registerSpawn(spawns, entry, (EntityType<? extends LivingEntity>)EntityType.f_20458_, (EntityType<? extends LivingEntity>)((EntityType)InstrumentalRegistry.CYMBAL_HUSK.get()));
                InstrumentalEntities.registerSpawn(spawns, entry, (EntityType<? extends LivingEntity>)EntityType.f_20501_, (EntityType<? extends LivingEntity>)((EntityType)InstrumentalRegistry.DRUM_ZOMBIE.get()));
                InstrumentalEntities.registerSpawn(spawns, entry, (EntityType<? extends LivingEntity>)EntityType.f_20558_, (EntityType<? extends LivingEntity>)((EntityType)InstrumentalRegistry.FRENCH_HORN_CREEPER.get()));
                InstrumentalEntities.registerSpawn(spawns, entry, (EntityType<? extends LivingEntity>)EntityType.f_20479_, (EntityType<? extends LivingEntity>)((EntityType)InstrumentalRegistry.MARACA_SPIDER.get()));
                InstrumentalEntities.registerSpawn(spawns, entry, (EntityType<? extends LivingEntity>)EntityType.f_20453_, (EntityType<? extends LivingEntity>)((EntityType)InstrumentalRegistry.MICROPHONE_GHAST.get()));
                InstrumentalEntities.registerSpawn(spawns, entry, (EntityType<? extends LivingEntity>)EntityType.f_20566_, (EntityType<? extends LivingEntity>)((EntityType)InstrumentalRegistry.TUBA_ENDERMAN.get()));
                InstrumentalEntities.registerSpawn(spawns, entry, (EntityType<? extends LivingEntity>)EntityType.f_20524_, (EntityType<? extends LivingEntity>)((EntityType)InstrumentalRegistry.XYLOPHONE_SKELETON.get()));
            }
        }
    }

    public static void initializeMobs() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)InstrumentalRegistry.CYMBAL_HUSK.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CymbalHuskEntity::canSpawnHere);
        SpawnPlacements.m_21754_((EntityType)((EntityType)InstrumentalRegistry.DRUM_ZOMBIE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)InstrumentalRegistry.FRENCH_HORN_CREEPER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)InstrumentalRegistry.MARACA_SPIDER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)InstrumentalRegistry.MICROPHONE_GHAST.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MicrophoneGhastEntity::canSpawnHere);
        SpawnPlacements.m_21754_((EntityType)((EntityType)InstrumentalRegistry.TUBA_ENDERMAN.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)InstrumentalRegistry.XYLOPHONE_SKELETON.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
    }

    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)InstrumentalRegistry.CYMBAL_HUSK.get(), Zombie.m_34328_().m_22265_());
        event.put((EntityType)InstrumentalRegistry.DRUM_ZOMBIE.get(), Zombie.m_34328_().m_22265_());
        event.put((EntityType)InstrumentalRegistry.FRENCH_HORN_CREEPER.get(), Creeper.m_32318_().m_22265_());
        event.put((EntityType)InstrumentalRegistry.MARACA_SPIDER.get(), Spider.m_33815_().m_22265_());
        event.put((EntityType)InstrumentalRegistry.MICROPHONE_GHAST.get(), Ghast.m_32752_().m_22265_());
        event.put((EntityType)InstrumentalRegistry.TUBA_ENDERMAN.get(), EnderMan.m_32541_().m_22265_());
        event.put((EntityType)InstrumentalRegistry.XYLOPHONE_SKELETON.get(), AbstractSkeleton.m_32166_().m_22265_());
    }

    public static void registerSpawn(List<MobSpawnSettings.SpawnerData> spawns, MobSpawnSettings.SpawnerData entry, EntityType<? extends LivingEntity> oldEntity, EntityType<? extends LivingEntity> newEntity) {
        if (entry.f_48404_ == oldEntity) {
            spawns.add(new MobSpawnSettings.SpawnerData(newEntity, Math.min(1, entry.m_142631_().m_146281_() / 5), entry.f_48405_, entry.f_48406_));
        }
    }
}

