/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.init;

import com.mrbysco.instrumentalmobs.blocks.DrumBlock;
import com.mrbysco.instrumentalmobs.entities.CymbalHuskEntity;
import com.mrbysco.instrumentalmobs.entities.DrumZombieEntity;
import com.mrbysco.instrumentalmobs.entities.FrenchHornCreeperEntity;
import com.mrbysco.instrumentalmobs.entities.MaracaSpiderEntity;
import com.mrbysco.instrumentalmobs.entities.MicrophoneGhastEntity;
import com.mrbysco.instrumentalmobs.entities.TubaEndermanEntity;
import com.mrbysco.instrumentalmobs.entities.XylophoneSkeletonEntity;
import com.mrbysco.instrumentalmobs.entities.projectiles.EntityMicrophoneWave;
import com.mrbysco.instrumentalmobs.entities.projectiles.EntitySoundWaves;
import com.mrbysco.instrumentalmobs.init.InstrumentalTab;
import com.mrbysco.instrumentalmobs.items.DrumInstrument;
import com.mrbysco.instrumentalmobs.items.InstrumentItem;
import com.mrbysco.instrumentalmobs.items.InstrumentMicrophone;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class InstrumentalRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"instrumentalmobs");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"instrumentalmobs");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"instrumentalmobs");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"instrumentalmobs");
    public static final RegistryObject<Block> DRUM_BLOCK = BLOCKS.register("drum_block", () -> new DrumBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76272_, (MaterialColor)MaterialColor.f_76406_).m_60978_(0.8f).m_60918_(SoundType.f_56745_).m_60955_()));
    public static final RegistryObject<Item> DRUM_BLOCK_ITEM = ITEMS.register("drum_block", () -> new BlockItem((Block)DRUM_BLOCK.get(), InstrumentalRegistry.itemBuilder()));
    public static final RegistryObject<Item> DRUM_ITEM = ITEMS.register("drum", () -> new DrumInstrument(InstrumentalRegistry.itemBuilder().m_41487_(1).m_41503_(140), () -> (SoundEvent)drum_sound.get(), 30, 40));
    public static final RegistryObject<Item> cymbal = ITEMS.register("cymbal", () -> new Item(InstrumentalRegistry.itemBuilder().m_41487_(1)));
    public static final RegistryObject<Item> cymbals = ITEMS.register("cymbals", () -> new InstrumentItem(InstrumentalRegistry.itemBuilder().m_41487_(1).m_41503_(100), () -> (SoundEvent)cymbals_sound.get(), 30, 40));
    public static final RegistryObject<Item> french_horn = ITEMS.register("french_horn", () -> new InstrumentItem(InstrumentalRegistry.itemBuilder().m_41487_(1).m_41503_(165), () -> (SoundEvent)french_horn_sound.get(), 40, 50));
    public static final RegistryObject<Item> maraca = ITEMS.register("maraca", () -> new Item(InstrumentalRegistry.itemBuilder().m_41487_(1)));
    public static final RegistryObject<Item> maracas = ITEMS.register("maracas", () -> new InstrumentItem(InstrumentalRegistry.itemBuilder().m_41487_(1).m_41503_(125), () -> (SoundEvent)maraca_sound.get(), 30, 20));
    public static final RegistryObject<Item> microphone = ITEMS.register("microphone", () -> new InstrumentMicrophone(InstrumentalRegistry.itemBuilder().m_41487_(1).m_41503_(110), () -> SoundEvents.f_11922_, 40, 40));
    public static final RegistryObject<Item> tuba = ITEMS.register("tuba", () -> new InstrumentItem(InstrumentalRegistry.itemBuilder().m_41487_(1).m_41487_(180), () -> (SoundEvent)tuba_sound.get(), 20, 40));
    public static final RegistryObject<Item> xylophone = ITEMS.register("xylophone", () -> new InstrumentItem(InstrumentalRegistry.itemBuilder().m_41487_(1).m_41503_(160), () -> (SoundEvent)xylophone_sound.get(), 30, 30));
    public static final RegistryObject<Item> CYMBAL_HUSK_SPAWN_EGG = ITEMS.register("cymbal_husk_spawn_egg", () -> new ForgeSpawnEggItem(() -> (EntityType)CYMBAL_HUSK.get(), 7958625, 15125652, InstrumentalRegistry.itemBuilder()));
    public static final RegistryObject<Item> DRUM_ZOMBIE_SPAWN_EGG = ITEMS.register("drum_zombie_spawn_egg", () -> new ForgeSpawnEggItem(() -> (EntityType)DRUM_ZOMBIE.get(), 44975, 7969893, InstrumentalRegistry.itemBuilder()));
    public static final RegistryObject<Item> FRENCH_HORN_CREEPER_SPAWN_EGG = ITEMS.register("french_horn_creeper_spawn_egg", () -> new ForgeSpawnEggItem(() -> (EntityType)FRENCH_HORN_CREEPER.get(), 894731, 0, InstrumentalRegistry.itemBuilder()));
    public static final RegistryObject<Item> MARACA_SPIDER_SPAWN_EGG = ITEMS.register("maraca_spider_spawn_egg", () -> new ForgeSpawnEggItem(() -> (EntityType)MARACA_SPIDER.get(), 803406, 11013646, InstrumentalRegistry.itemBuilder()));
    public static final RegistryObject<Item> MICROPHONE_GHAST_SPAWN_EGG = ITEMS.register("microphone_ghast_spawn_egg", () -> new ForgeSpawnEggItem(() -> (EntityType)MICROPHONE_GHAST.get(), 0xF9F9F9, 0xBCBCBC, InstrumentalRegistry.itemBuilder()));
    public static final RegistryObject<Item> TUBA_ENDERMAN_SPAWN_EGG = ITEMS.register("tuba_enderman_spawn_egg", () -> new ForgeSpawnEggItem(() -> (EntityType)TUBA_ENDERMAN.get(), 0x161616, 0, InstrumentalRegistry.itemBuilder()));
    public static final RegistryObject<Item> XYLOPHONE_SKELETON_SPAWN_EGG = ITEMS.register("xylophone_skeleton_spawn_egg", () -> new ForgeSpawnEggItem(() -> (EntityType)XYLOPHONE_SKELETON.get(), 0xC1C1C1, 0x494949, InstrumentalRegistry.itemBuilder()));
    public static final RegistryObject<EntityType<CymbalHuskEntity>> CYMBAL_HUSK = ENTITIES.register("cymbal_husk", () -> InstrumentalRegistry.register("cymbal_husk", EntityType.Builder.m_20704_(CymbalHuskEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20702_(8)));
    public static final RegistryObject<EntityType<DrumZombieEntity>> DRUM_ZOMBIE = ENTITIES.register("drum_zombie", () -> InstrumentalRegistry.register("drum_zombie", EntityType.Builder.m_20704_(DrumZombieEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20702_(8)));
    public static final RegistryObject<EntityType<FrenchHornCreeperEntity>> FRENCH_HORN_CREEPER = ENTITIES.register("french_horn_creeper", () -> InstrumentalRegistry.register("french_horn_creeper", EntityType.Builder.m_20704_(FrenchHornCreeperEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.7f).m_20702_(8)));
    public static final RegistryObject<EntityType<MaracaSpiderEntity>> MARACA_SPIDER = ENTITIES.register("maraca_spider", () -> InstrumentalRegistry.register("maraca_spider", EntityType.Builder.m_20704_(MaracaSpiderEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.4f, 0.9f).m_20702_(8)));
    public static final RegistryObject<EntityType<MicrophoneGhastEntity>> MICROPHONE_GHAST = ENTITIES.register("microphone_ghast", () -> InstrumentalRegistry.register("microphone_ghast", EntityType.Builder.m_20704_(MicrophoneGhastEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(4.0f, 4.0f).m_20719_().m_20702_(10)));
    public static final RegistryObject<EntityType<TubaEndermanEntity>> TUBA_ENDERMAN = ENTITIES.register("tuba_enderman", () -> InstrumentalRegistry.register("tuba_enderman", EntityType.Builder.m_20704_(TubaEndermanEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 2.9f).m_20702_(8)));
    public static final RegistryObject<EntityType<XylophoneSkeletonEntity>> XYLOPHONE_SKELETON = ENTITIES.register("xylophone_skeleton", () -> InstrumentalRegistry.register("xylophone_skeleton", EntityType.Builder.m_20704_(XylophoneSkeletonEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.99f).m_20702_(8)));
    public static final RegistryObject<EntityType<EntityMicrophoneWave>> MICROPHONE_WAVE = ENTITIES.register("microphone_sound", () -> InstrumentalRegistry.register("microphone_sound", EntityType.Builder.m_20704_(EntityMicrophoneWave::new, (MobCategory)MobCategory.MISC).m_20699_(0.3125f, 0.3125f).m_20702_(4).m_20702_(10).setCustomClientFactory(EntityMicrophoneWave::new)));
    public static final RegistryObject<EntityType<EntitySoundWaves>> SOUND_WAVE = ENTITIES.register("sound_waves", () -> InstrumentalRegistry.register("sound_waves", EntityType.Builder.m_20704_(EntitySoundWaves::new, (MobCategory)MobCategory.MISC).m_20699_(0.3125f, 0.3125f).m_20702_(4).m_20702_(10).setCustomClientFactory(EntitySoundWaves::new)));
    public static final RegistryObject<SoundEvent> cymbals_sound = SOUND_EVENTS.register("cymbal.sound", () -> InstrumentalRegistry.createSound("cymbal.sound"));
    public static final RegistryObject<SoundEvent> drum_sound = SOUND_EVENTS.register("drum.sound", () -> InstrumentalRegistry.createSound("drum.sound"));
    public static final RegistryObject<SoundEvent> french_horn_sound = SOUND_EVENTS.register("frenchhorn.sound", () -> InstrumentalRegistry.createSound("frenchhorn.sound"));
    public static final RegistryObject<SoundEvent> maraca_sound = SOUND_EVENTS.register("maraca.sound", () -> InstrumentalRegistry.createSound("maraca.sound"));
    public static final RegistryObject<SoundEvent> single_drum_sound = SOUND_EVENTS.register("drum.single.sound", () -> InstrumentalRegistry.createSound("drum.single.sound"));
    public static final RegistryObject<SoundEvent> tuba_sound = SOUND_EVENTS.register("tuba.sound", () -> InstrumentalRegistry.createSound("tuba.sound"));
    public static final RegistryObject<SoundEvent> xylophone_sound = SOUND_EVENTS.register("xylophone.sound", () -> InstrumentalRegistry.createSound("xylophone.sound"));

    public static <T extends Entity> EntityType<T> register(String id, EntityType.Builder<T> builder, boolean sendVelocityUpdates) {
        return builder.setShouldReceiveVelocityUpdates(sendVelocityUpdates).m_20712_(id);
    }

    public static <T extends Entity> EntityType<T> register(String id, EntityType.Builder<T> builder) {
        return InstrumentalRegistry.register(id, builder, true);
    }

    private static SoundEvent createSound(String name) {
        ResourceLocation resourceLocation = new ResourceLocation("instrumentalmobs", name);
        return new SoundEvent(resourceLocation);
    }

    private static Item.Properties itemBuilder() {
        return new Item.Properties().m_41491_(InstrumentalTab.INSTRUMENTAL_TAB);
    }
}

