/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.components;

import com.robertx22.library_of_exile.components.EntityDmgStatsData;
import com.robertx22.library_of_exile.components.MySpawnReason;
import com.robertx22.library_of_exile.components.forge.BaseProvider;
import com.robertx22.library_of_exile.components.forge.BaseStorage;
import com.robertx22.library_of_exile.components.forge.ICommonCap;
import com.robertx22.library_of_exile.utils.LoadSave;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EntityInfoComponent {
    public static final ResourceLocation RESOURCE = new ResourceLocation("library_of_exile", "entity_info");
    @CapabilityInject(value=IEntityInfo.class)
    public static final Capability<IEntityInfo> Data = null;
    private static final String DMG_STATS = "dmg_stats";
    private static final String SPAWN_POS = "spawn_pos";
    private static final String SPAWN_REASON = "spawn";

    public static IEntityInfo get(LivingEntity entity) {
        return (IEntityInfo)entity.getCapability(Data).orElse(null);
    }

    public static class DefaultImpl
    implements IEntityInfo {
        EntityDmgStatsData dmgStats = new EntityDmgStatsData();
        private BlockPos spawnPos;
        public MySpawnReason spawnReason = null;
        public LivingEntity owner;

        public DefaultImpl(LivingEntity en) {
            this.owner = en;
        }

        @Override
        public BlockPos getSpawnPos() {
            if (this.spawnPos != null) {
                return this.spawnPos;
            }
            return BlockPos.field_177992_a;
        }

        @Override
        public void spawnInit(Entity entity) {
            if (this.spawnPos == null || this.spawnPos.func_177958_n() == 0 && this.spawnPos.func_177956_o() == 0 && this.spawnPos.func_177952_p() == 0) {
                this.spawnPos = entity.func_233580_cy_();
            }
        }

        @Override
        public MySpawnReason getSpawnReason() {
            return this.spawnReason == null ? MySpawnReason.OTHER : this.spawnReason;
        }

        @Override
        public void setSpawnReasonOnCreate(SpawnReason reason) {
            if (this.spawnReason == null) {
                this.spawnReason = MySpawnReason.get(reason);
            }
        }

        @Override
        public EntityDmgStatsData getDamageStats() {
            return this.dmgStats;
        }

        @Override
        public CompoundNBT saveToNBT() {
            CompoundNBT nbt = new CompoundNBT();
            try {
                if (this.dmgStats != null) {
                    LoadSave.Save(this.dmgStats, nbt, EntityInfoComponent.DMG_STATS);
                }
                if (this.spawnPos != null) {
                    nbt.func_74772_a(EntityInfoComponent.SPAWN_POS, this.spawnPos.func_218275_a());
                }
                nbt.func_74778_a(this.getSpawnReason().name(), EntityInfoComponent.SPAWN_REASON);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return nbt;
        }

        @Override
        public void loadFromNBT(CompoundNBT nbt) {
            try {
                this.dmgStats = LoadSave.Load(EntityDmgStatsData.class, new EntityDmgStatsData(), nbt, EntityInfoComponent.DMG_STATS);
                if (this.dmgStats == null) {
                    this.dmgStats = new EntityDmgStatsData();
                }
                this.spawnPos = BlockPos.func_218283_e((long)nbt.func_74763_f(EntityInfoComponent.SPAWN_POS));
                String res = nbt.func_74779_i(EntityInfoComponent.SPAWN_REASON);
                this.spawnReason = res != null && !res.isEmpty() ? MySpawnReason.valueOf(res) : MySpawnReason.OTHER;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class Storage
    implements BaseStorage<IEntityInfo> {
    }

    public static class Provider
    extends BaseProvider<IEntityInfo, LivingEntity> {
        public Provider(LivingEntity owner) {
            super(owner);
        }

        @Override
        public IEntityInfo newDefaultImpl(LivingEntity owner) {
            return new DefaultImpl(owner);
        }

        @Override
        public Capability<IEntityInfo> dataInstance() {
            return Data;
        }
    }

    public static interface IEntityInfo
    extends ICommonCap,
    BaseStorage<IEntityInfo> {
        public EntityDmgStatsData getDamageStats();

        public BlockPos getSpawnPos();

        public void spawnInit(Entity var1);

        public MySpawnReason getSpawnReason();

        public void setSpawnReasonOnCreate(SpawnReason var1);
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onEntityConstruct(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof LivingEntity) {
                event.addCapability(RESOURCE, (ICapabilityProvider)new Provider((LivingEntity)event.getObject()));
            }
        }
    }
}

