/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.components;

import com.robertx22.library_of_exile.components.forge.ICommonCap;
import com.robertx22.library_of_exile.components.forge.IPlayerCap;
import java.util.HashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class PlayerCapabilities {
    static HashMap<String, Capability<? extends IPlayerCap>> caps = new HashMap();

    public static void register(Capability<? extends IPlayerCap> cap, IPlayerCap obj) {
        caps.put(obj.getCapIdForSyncing(), cap);
    }

    public static void saveAllOnDeath(PlayerEvent.Clone event) {
        caps.values().forEach(x -> {
            PlayerEntity original = event.getOriginal();
            PlayerEntity current = event.getPlayer();
            try {
                ICommonCap data = (ICommonCap)current.getCapability(x).orElse(null);
                data.loadFromNBT(((IPlayerCap)original.getCapability(x).orElse(null)).saveToNBT());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void syncAllToClient(PlayerEntity player) {
        try {
            caps.values().forEach(x -> ((IPlayerCap)player.getCapability(x).orElse(null)).syncToClient(player));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static IPlayerCap get(PlayerEntity player, String id) {
        if (caps.containsKey(id)) {
            Capability<? extends IPlayerCap> cap = caps.get(id);
            return (IPlayerCap)player.getCapability(cap).orElse(null);
        }
        return null;
    }
}

