/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.components.forge;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public abstract class BaseProvider<TYPE, OWNER_CLASS>
implements ICapabilitySerializable<CompoundNBT> {
    public OWNER_CLASS owner;
    TYPE impl;
    private final LazyOptional<TYPE> cap;

    public BaseProvider(OWNER_CLASS owner) {
        this.owner = owner;
        this.impl = this.newDefaultImpl(owner);
        this.cap = LazyOptional.of(() -> this.impl);
    }

    public abstract TYPE newDefaultImpl(OWNER_CLASS var1);

    public abstract Capability<TYPE> dataInstance();

    public CompoundNBT serializeNBT() {
        return (CompoundNBT)this.dataInstance().getStorage().writeNBT(this.dataInstance(), this.impl, null);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.dataInstance().getStorage().readNBT(this.dataInstance(), this.impl, null, (INBT)nbt);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == this.dataInstance()) {
            return this.cap.cast();
        }
        return LazyOptional.empty();
    }
}

