/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.packets;

import com.robertx22.library_of_exile.components.PlayerCapabilities;
import com.robertx22.library_of_exile.components.forge.IPlayerCap;
import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.packets.ExilePacketContext;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class SyncPlayerCapToClient
extends MyPacket<SyncPlayerCapToClient> {
    public String capid;
    public CompoundNBT nbt;

    public SyncPlayerCapToClient() {
    }

    public SyncPlayerCapToClient(PlayerEntity player, String capid) {
        this.nbt = PlayerCapabilities.get(player, capid).saveToNBT();
        this.capid = capid;
    }

    @Override
    public ResourceLocation getIdentifier() {
        return new ResourceLocation("library_of_exile", "syncplayercap");
    }

    @Override
    public void loadFromData(PacketBuffer tag) {
        this.capid = tag.func_150789_c(100);
        this.nbt = tag.func_150793_b();
    }

    @Override
    public void saveToData(PacketBuffer tag) {
        tag.func_211400_a(this.capid, 100);
        tag.func_150786_a(this.nbt);
    }

    @Override
    public void onReceived(ExilePacketContext ctx) {
        try {
            IPlayerCap cap;
            PlayerEntity player = ctx.getPlayer();
            if (player.field_70170_p.field_72995_K && (cap = PlayerCapabilities.get(player, this.capid)) != null) {
                cap.loadFromNBT(this.nbt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public MyPacket<SyncPlayerCapToClient> newInstance() {
        return new SyncPlayerCapToClient();
    }
}

