/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.packets.particles;

import com.robertx22.library_of_exile.main.Packets;
import com.robertx22.library_of_exile.packets.particles.ParticlePacket;
import com.robertx22.library_of_exile.packets.particles.ParticlePacketData;
import com.robertx22.library_of_exile.utils.GeometryUtils;
import com.robertx22.library_of_exile.utils.RGB;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public enum ParticleEnum {
    THORNS{

        @Override
        public void activate(ParticlePacketData data, World world) {
            Vector3d center = this.getCenter(data);
            for (int i = 0; i < data.amount; ++i) {
                Vector3d p = GeometryUtils.randomPos(center, world.field_73012_v, data.radius);
                Vector3d m = GeometryUtils.randomMotion(center, world.field_73012_v);
                world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196647_Y.func_176223_P()), p.field_72450_a, p.field_72448_b, p.field_72449_c, m.field_72450_a, m.field_72448_b, m.field_72449_c);
                world.func_195594_a((IParticleData)ParticleTypes.field_197592_C, p.field_72450_a, p.field_72448_b, p.field_72449_c, m.field_72450_a, m.field_72448_b, m.field_72449_c);
            }
        }
    }
    ,
    AOE{

        @Override
        public void activate(ParticlePacketData data, World world) {
            Vector3d p = this.getCenter(data);
            for (int i = 0; i < data.amount; ++i) {
                Vector3d r = GeometryUtils.getRandomPosInRadiusCircle(p.field_72450_a, p.field_72448_b, p.field_72449_c, data.radius);
                world.func_195594_a(data.getParticleType(), r.field_72450_a, r.field_72448_b, r.field_72449_c, data.mx, data.my, data.mz);
            }
        }
    }
    ,
    CIRCLE_REDSTONE{

        @Override
        public void activate(ParticlePacketData data, World world) {
            Vector3d p = this.getCenter(data);
            int i = 0;
            while ((float)i < data.radius * 60.0f) {
                Vector3d r = GeometryUtils.getRandomPosInRadiusCircle(p.field_72450_a, p.field_72448_b, p.field_72449_c, data.radius);
                this.spawnRedstone(world, data.color, r.field_72450_a, r.field_72448_b, r.field_72449_c);
                ++i;
            }
        }
    }
    ,
    NOVA_REDSTONE{

        @Override
        public void activate(ParticlePacketData data, World world) {
            Vector3d p = this.getCenter(data);
            int i = 0;
            while ((float)i < data.radius * 50.0f) {
                Vector3d r = GeometryUtils.getRandomHorizontalPosInRadiusCircle(p.field_72450_a, p.field_72448_b, p.field_72449_c, data.radius);
                this.spawnRedstone(world, data.color, r.field_72450_a, r.field_72448_b, r.field_72449_c);
                ++i;
            }
        }
    }
    ,
    NOVA{

        @Override
        public void activate(ParticlePacketData data, World world) {
            Vector3d p = this.getCenter(data);
            for (int i = 0; i < data.amount; ++i) {
                Vector3d r = GeometryUtils.getRandomHorizontalPosInRadiusCircle(p.field_72450_a, p.field_72448_b, p.field_72449_c, data.radius);
                world.func_195594_a(data.getParticleType(), r.field_72450_a, r.field_72448_b, r.field_72449_c, 0.0, 0.0, 0.0);
            }
        }
    };


    public static void sendToClients(Entity source, ParticlePacketData data) {
        if (source.field_70170_p.field_72995_K) {
            try {
                data.type.activate(data, source.field_70170_p);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Packets.sendToTracking(new ParticlePacket(data), source);
        }
    }

    public static void sendToClients(BlockPos pos, World world, ParticlePacketData data) {
        if (!world.field_72995_K) {
            Packets.sendToTracking(new ParticlePacket(data), pos, world);
        } else {
            data.type.activate(data, world);
        }
    }

    public Vector3d getCenter(ParticlePacketData data) {
        if (data.isVecPos) {
            return data.getPos();
        }
        BlockPos pos = data.getBlockPos();
        return new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public void spawnRedstone(World world, RGB color, double xpos, double ypos, double zpos) {
        RedstoneParticleData data = new RedstoneParticleData(color.getR(), color.getG(), color.getB(), 1.0f);
        world.func_195590_a((IParticleData)data, true, xpos, ypos, zpos, 1.0, 1.0, 1.0);
    }

    public abstract void activate(ParticlePacketData var1, World var2);
}

