/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.packets.particles;

import com.robertx22.library_of_exile.packets.particles.ParticleEnum;
import com.robertx22.library_of_exile.utils.RGB;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;

@Storable
public class ParticlePacketData {
    @Store
    public double x = 1.0;
    @Store
    public double y = 1.0;
    @Store
    public double z = 1.0;
    @Store
    public boolean isVecPos = false;
    @Store
    public double mx = 1.0;
    @Store
    public double my = 1.0;
    @Store
    public double mz = 1.0;
    @Store
    public ParticleEnum type;
    @Store
    public float radius = 1.0f;
    @Store
    public int amount = 1;
    @Store
    public RGB color;
    @Store
    public String particleID;

    private ParticlePacketData() {
    }

    public static ParticlePacketData empty() {
        return new ParticlePacketData();
    }

    public <T extends IParticleData> IParticleData getParticleType() {
        ParticleType particleType = (ParticleType)Registry.field_212632_u.func_82594_a(new ResourceLocation(this.particleID));
        if (particleType instanceof IParticleData) {
            return (IParticleData)particleType;
        }
        return ParticleTypes.field_197614_g;
    }

    public ParticlePacketData motion(Vector3d v) {
        this.mx = v.field_72450_a;
        this.my = v.field_72448_b;
        this.mz = v.field_72449_c;
        return this;
    }

    public ParticlePacketData type(ParticleType type) {
        this.particleID = Registry.field_212632_u.func_177774_c((Object)type).toString();
        return this;
    }

    public ParticlePacketData amount(int num) {
        this.amount = num;
        return this;
    }

    public ParticlePacketData radius(double rad) {
        this.radius = (float)rad;
        return this;
    }

    public ParticlePacketData radius(float rad) {
        this.radius = rad;
        return this;
    }

    public ParticlePacketData color(RGB color) {
        this.color = color;
        return this;
    }

    public Vector3d getPos() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public ParticlePacketData(Vector3d pos, ParticleEnum type) {
        this.x = pos.func_82615_a();
        this.y = pos.func_82617_b();
        this.z = pos.func_82616_c();
        this.isVecPos = true;
        this.type = type;
    }

    public ParticlePacketData(BlockPos pos, ParticleEnum type) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.type = type;
    }
}

