/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.packets.registry;

import com.google.common.collect.Lists;
import com.robertx22.library_of_exile.main.LibraryOfExile;
import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.packets.ExilePacketContext;
import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryContainer;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.library_of_exile.registry.serialization.IByteBuf;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class EfficientRegistryPacket<T extends IByteBuf & JsonExileRegistry>
extends MyPacket<EfficientRegistryPacket> {
    public static ResourceLocation ID = new ResourceLocation("library_of_exile", "eff_reg");
    private List<T> items;
    ExileRegistryType type;

    public EfficientRegistryPacket() {
    }

    public EfficientRegistryPacket(ExileRegistryType type, List<T> list) {
        this.type = type;
        this.items = list;
    }

    @Override
    public ResourceLocation getIdentifier() {
        return ID;
    }

    @Override
    public void loadFromData(PacketBuffer buf) {
        this.type = ExileRegistryType.get(buf.func_150789_c(30));
        if (LibraryOfExile.runDevTools()) {
            // empty if block
        }
        IByteBuf serializer = (IByteBuf)((Object)this.type.getSerializer());
        this.items = Lists.newArrayList();
        int i = buf.func_150792_a();
        for (int j = 0; j < i; ++j) {
            this.items.add(serializer.getFromBuf(buf));
        }
    }

    @Override
    public void saveToData(PacketBuffer buf) {
        buf.func_211400_a(this.type.id, 30);
        buf.func_150787_b(this.items.size());
        this.items.forEach(x -> x.toBuf(buf));
    }

    @Override
    public void onReceived(ExilePacketContext ctx) {
        ExileRegistryContainer reg = Database.getRegistry(this.type);
        reg.unregisterAllEntriesFromDatapacks();
        this.items.forEach(x -> ((ExileRegistry)((Object)x)).registerToExileRegistry());
        System.out.println("Efficient " + this.type.id + " reg load on client success with: " + reg.getSize() + " entries.");
    }

    @Override
    public MyPacket<EfficientRegistryPacket> newInstance() {
        return new EfficientRegistryPacket<T>();
    }
}

