/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.packets.registry;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.robertx22.library_of_exile.main.LibraryOfExile;
import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.packets.ExilePacketContext;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.library_of_exile.registry.ListStringData;
import com.robertx22.library_of_exile.registry.RegistryPackets;
import com.robertx22.library_of_exile.utils.LoadSave;
import com.robertx22.library_of_exile.utils.Watch;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class RegistryPacket
extends MyPacket<RegistryPacket> {
    public static ResourceLocation ID = new ResourceLocation("library_of_exile", "reg");
    public static final JsonParser PARSER = new JsonParser();
    ExileRegistryType type;
    ListStringData data;

    public RegistryPacket() {
    }

    public <T extends JsonExileRegistry> RegistryPacket(ExileRegistryType type, ListStringData data) {
        this.type = type;
        this.data = data;
    }

    @Override
    public ResourceLocation getIdentifier() {
        return ID;
    }

    @Override
    public void loadFromData(PacketBuffer tag) {
        try {
            this.type = ExileRegistryType.get(tag.func_150789_c(30));
            if (LibraryOfExile.runDevTools()) {
                // empty if block
            }
            CompoundNBT nbt = tag.func_150793_b();
            this.data = LoadSave.Load(ListStringData.class, new ListStringData(), nbt, "data");
        }
        catch (Exception e) {
            System.out.println("Failed reading Age of Exile packet to bufferer.");
            e.printStackTrace();
        }
    }

    @Override
    public void saveToData(PacketBuffer tag) {
        try {
            Watch watch = new Watch().min(8000);
            tag.func_211400_a(this.type.id, 30);
            CompoundNBT nbt = new CompoundNBT();
            LoadSave.Save(this.data, nbt, "data");
            tag.func_150786_a(nbt);
            watch.print("Writing gson packet for " + this.type.id + " ");
        }
        catch (Exception e) {
            System.out.println("Failed saving " + this.type.id + " Age of Exile packet to bufferer.");
            e.printStackTrace();
        }
    }

    @Override
    public void onReceived(ExilePacketContext ctx) {
        if (this.data.getList().isEmpty()) {
            throw new RuntimeException("Registry list sent from server is empty!");
        }
        List<JsonObject> set = RegistryPackets.get(this.type);
        this.data.getList().forEach(x -> {
            try {
                JsonObject json = (JsonObject)PARSER.parse(x);
                set.add(json);
            }
            catch (JsonSyntaxException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public MyPacket<RegistryPacket> newInstance() {
        return new RegistryPacket();
    }
}

