/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.registry;

import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryContainer;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.SyncTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;

public class Database {
    private static HashMap<ExileRegistryType, ExileRegistryContainer> SERVER = new HashMap();
    private static HashMap<ExileRegistryType, ExileRegistryContainer> BACKUP = new HashMap();

    public static boolean areDatapacksLoaded(World world) {
        return ExileRegistryType.getInRegisterOrder(SyncTime.ON_LOGIN).stream().allMatch(x -> Database.getRegistry(x).isRegistrationDone());
    }

    public static void backup() {
        BACKUP = new HashMap<ExileRegistryType, ExileRegistryContainer>(SERVER);
    }

    public static void restoreBackup() {
        System.out.print("Restoring registry backup, this should never happen!");
        SERVER = new HashMap<ExileRegistryType, ExileRegistryContainer>(BACKUP);
    }

    public static void restoreFromBackupifEmpty() {
        if (SERVER.isEmpty()) {
            Database.restoreBackup();
        }
    }

    public static List<ExileRegistryContainer> getAllRegistries() {
        return new ArrayList<ExileRegistryContainer>(SERVER.values());
    }

    public static ExileRegistryContainer getRegistry(ExileRegistryType type) {
        return SERVER.get(type);
    }

    public static ExileRegistry get(ExileRegistryType type, String guid) {
        return Database.getRegistry(type).get(guid);
    }

    public static void sendPacketsToClient(ServerPlayerEntity player, SyncTime sync) {
        List<ExileRegistryType> list = ExileRegistryType.getInRegisterOrder(sync);
        list.forEach(x -> Database.getRegistry(x).sendUpdatePacket(player));
    }

    public static void checkGuidValidity() {
        SERVER.values().forEach(c -> c.getAllIncludingSeriazable().forEach(x -> {
            ExileRegistry entry = (ExileRegistry)x;
            if (!entry.isGuidFormattedCorrectly()) {
                throw new RuntimeException(entry.getInvalidGuidMessage());
            }
        }));
    }

    public static void unregisterInvalidEntries() {
        System.out.println("Starting Age of Exile Registry auto validation.");
        ArrayList invalid = new ArrayList();
        SERVER.values().forEach(c -> c.getList().forEach(x -> {
            ExileRegistry entry = (ExileRegistry)x;
            if (!entry.isRegistryEntryValid()) {
                invalid.add(entry);
            }
        }));
        invalid.forEach(x -> x.unregisterDueToInvalidity());
        if (invalid.isEmpty()) {
            System.out.println("All Age of Exile registries appear valid.");
        } else {
            System.out.println(invalid.size() + " Age of Exile entries are INVALID!");
        }
    }

    public static void addRegistry(ExileRegistryContainer cont) {
        SERVER.put(cont.getType(), cont);
    }

    public static void initRegistries() {
        SERVER = new HashMap();
        ExileRegistryType.init();
    }
}

