/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.registry;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.robertx22.library_of_exile.registry.BaseDatapackGenerator;
import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.library_of_exile.registry.serialization.ISerializable;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;

public class ExileDatapackGenerator<T extends IGUID & ISerializable<T>>
extends BaseDatapackGenerator<T> {
    String modid;

    public ExileDatapackGenerator(String modid, List<T> list, String category) {
        super(list, category);
        this.modid = modid;
    }

    @Override
    public void run() {
        this.generateAll(this.cache);
    }

    public Path resolve(Path path, T object) {
        return path.resolve("data/" + this.modid + "/" + this.category + "/" + ((ISerializable)object).datapackFolder() + object.getFileName().replaceAll(":", "_") + ".json");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void generateAll(DirectoryCache cache) {
        try {
            Path path = this.gameDirPath();
            for (IGUID entry : this.list) {
                if (!((ISerializable)((Object)entry)).shouldGenerateJson()) continue;
                Path target = this.movePath(this.resolve(path, entry));
                target = Paths.get(target.toString().replace("\\.\\", "\\"), new String[0]);
                try {
                    IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)((ISerializable)((Object)entry)).toJson(), (Path)target);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }
}

