/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.registry;

import com.google.common.base.Preconditions;
import com.robertx22.library_of_exile.main.Packets;
import com.robertx22.library_of_exile.packets.registry.EfficientRegistryPacket;
import com.robertx22.library_of_exile.packets.registry.RegistryPacket;
import com.robertx22.library_of_exile.registry.DataGenKey;
import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.FilterListWrap;
import com.robertx22.library_of_exile.registry.ListStringData;
import com.robertx22.library_of_exile.registry.serialization.IByteBuf;
import com.robertx22.library_of_exile.registry.serialization.ISerializable;
import com.robertx22.library_of_exile.utils.RandomUtils;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;

public class ExileRegistryContainer<C extends ExileRegistry> {
    private List<String> registersErrorsAlertedFor = new ArrayList<String>();
    private List<String> accessorErrosAletedFor = new ArrayList<String>();
    private List<String> emptyRegistries = new ArrayList<String>();
    private boolean dataPacksAreRegistered = true;
    boolean isDatapack = false;
    private HashMap<String, C> serializables = new HashMap();
    List<C> fromDatapacks = null;
    PacketBuffer cachedBuf = null;
    private ExileRegistryType type;
    private C emptyDefault;
    private HashMap<String, C> map = new HashMap();
    private boolean errorIfEmpty = true;
    private boolean logAdditionsToRegistry = false;
    private boolean logMissingEntryOnAccess = true;
    boolean accessedEarly = false;

    public ExileRegistryContainer<C> setIsDatapack() {
        this.dataPacksAreRegistered = false;
        this.isDatapack = true;
        return this;
    }

    public List<C> getSerializable() {
        return new ArrayList<C>(this.serializables.values());
    }

    public void sendUpdatePacket(ServerPlayerEntity player) {
        if (this.type.ser == null) {
            return;
        }
        Preconditions.checkNotNull((Object)this.cachedBuf, (Object)(this.type.id + " error, cachedbuf is null!!!"));
        if (this.type.ser instanceof IByteBuf) {
            Packets.sendToClient((PlayerEntity)player, new EfficientRegistryPacket<C>(this.type, this.getList()));
        } else {
            ListStringData data = new ListStringData(this.getFromDatapacks().stream().map(x -> ((ISerializable)((Object)x)).toJsonString()).collect(Collectors.toList()));
            Packets.sendToClient((PlayerEntity)player, new RegistryPacket(this.type, data));
        }
    }

    public void onAllDatapacksLoaded() {
        this.fromDatapacks = null;
        this.getFromDatapacks();
        if (this.fromDatapacks != null && !this.fromDatapacks.isEmpty()) {
            this.cachedBuf = new PacketBuffer(Unpooled.buffer());
            if (this.type.ser instanceof IByteBuf) {
                new EfficientRegistryPacket<C>(this.type, Database.getRegistry(this.type).getFromDatapacks()).saveToData(this.cachedBuf);
            } else {
                ListStringData data = new ListStringData(this.getFromDatapacks().stream().map(x -> ((ISerializable)((Object)x)).toJsonString()).collect(Collectors.toList()));
                new RegistryPacket(this.type, data).saveToData(this.cachedBuf);
            }
            Preconditions.checkNotNull((Object)this.cachedBuf);
        }
    }

    public List<C> getFromDatapacks() {
        if (this.fromDatapacks == null) {
            this.fromDatapacks = this.getList().stream().filter(x -> x.isFromDatapack()).collect(Collectors.toList());
        }
        return this.fromDatapacks;
    }

    public ExileRegistryType getType() {
        return this.type;
    }

    public static void logRegistryError(String text) {
        try {
            throw new Exception("[Age of Exile Registry Error]: " + text);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public C getDefault() {
        return this.emptyDefault;
    }

    public ExileRegistryContainer logAdditions() {
        this.logAdditionsToRegistry = true;
        return this;
    }

    public void unRegister(ExileRegistry entry) {
        this.map.remove(entry.GUID());
    }

    public ExileRegistryContainer dontErrorMissingEntriesOnAccess() {
        this.logMissingEntryOnAccess = false;
        return this;
    }

    public ExileRegistryContainer dontErrorIfEmpty() {
        this.errorIfEmpty = false;
        return this;
    }

    public int getSize() {
        return this.map.size();
    }

    public boolean isRegistrationDone() {
        return this.getSize() > 0;
    }

    public ExileRegistryContainer(ExileRegistryType type, C emptyDefault) {
        this.type = type;
        this.emptyDefault = emptyDefault;
    }

    public void setDefault(C c) {
        this.emptyDefault = c;
    }

    private void tryLogEmptyRegistry() {
        if (this.errorIfEmpty && this.map.isEmpty() && this.dataPacksAreRegistered && this.emptyRegistries.contains(this.type.id)) {
            this.emptyRegistries.add(this.type.id);
            ExileRegistryContainer.logRegistryError("Exile Registry of type: " + this.type.toString() + " is empty, this is really bad!");
        }
    }

    public HashMap<String, C> getAll() {
        this.tryLogEmptyRegistry();
        return this.map;
    }

    public List<C> getList() {
        if (!this.map.isEmpty()) {
            return new ArrayList<C>(this.map.values());
        }
        this.tryLogEmptyRegistry();
        return Arrays.asList(new ExileRegistry[0]);
    }

    public List<C> getAllIncludingSeriazable() {
        ArrayList<C> list = new ArrayList<C>(this.map.values());
        list.addAll(this.serializables.values());
        return list;
    }

    public void unregisterAllEntriesFromDatapacks() {
        this.map.entrySet().removeIf(x -> ((ExileRegistry)x.getValue()).isFromDatapack());
    }

    public C getFromSerializables(DataGenKey<C> key) {
        return (C)((ExileRegistry)this.serializables.get(key.GUID()));
    }

    public C get(String guid) {
        if (this.map.isEmpty() && this.serializables.isEmpty()) {
            if (!this.accessedEarly) {
                System.out.print("\n Accessed slash registry earlier than datapacks are loaded, returning empty: " + guid);
            }
            this.accessedEarly = true;
            return this.emptyDefault;
        }
        this.tryLogEmptyRegistry();
        if (guid == null || guid.isEmpty()) {
            return this.getDefault();
        }
        if (this.map.containsKey(guid)) {
            return (C)((ExileRegistry)this.map.get(guid));
        }
        if (this.serializables.containsKey(guid)) {
            return (C)((ExileRegistry)this.serializables.get(guid));
        }
        if (this.logMissingEntryOnAccess && !this.accessorErrosAletedFor.contains(guid)) {
            ExileRegistryContainer.logRegistryError("GUID Error: " + guid + " of type: " + this.type.id + " doesn't exist. This is either a removed/renamed old registry, or robertx22 forgot to include it in an update.");
            this.accessorErrosAletedFor.add(guid);
        }
        return this.getDefault();
    }

    public FilterListWrap<C> getWrapped() {
        return new FilterListWrap<C>(this.map.values());
    }

    public FilterListWrap<C> getFilterWrapped(Predicate<C> pred) {
        return new FilterListWrap<C>(this.getFiltered(pred));
    }

    public List<C> getFiltered(Predicate<C> predicate) {
        return this.getList().stream().filter(predicate).collect(Collectors.toList());
    }

    public C random() {
        return (C)((ExileRegistry)RandomUtils.weightedRandom(this.getList()));
    }

    public boolean isRegistered(C c) {
        return this.isRegistered(c.GUID());
    }

    public boolean isRegistered(String guid) {
        return this.map.containsKey(guid);
    }

    public void register(C c) {
        if (this.isRegistered(c)) {
            if (!this.registersErrorsAlertedFor.contains(c.GUID())) {
                ExileRegistryContainer.logRegistryError("Key: " + c.GUID() + " has already been registered to: " + c.getExileRegistryType().toString() + " registry.");
                this.registersErrorsAlertedFor.add(c.GUID());
            }
        } else {
            this.tryLogAddition(c);
            this.map.put(c.GUID(), c);
        }
    }

    private void tryLogAddition(C c) {
    }

    public void addSerializable(C entry) {
        if (this.serializables.containsKey(entry.GUID())) {
            System.out.println("Entry of type: " + entry.getExileRegistryType().id + " already exists as seriazable: " + entry.GUID());
        }
        this.serializables.put(entry.GUID(), entry);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

