/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.registry;

import com.google.gson.JsonObject;
import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileDatapackGenerator;
import com.robertx22.library_of_exile.registry.SyncTime;
import com.robertx22.library_of_exile.registry.loaders.BaseDataPackLoader;
import com.robertx22.library_of_exile.registry.serialization.ISerializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.SimpleReloadableResourceManager;

public class ExileRegistryType {
    private static List<ExileRegistryType> all = new ArrayList<ExileRegistryType>();
    private static HashMap<String, ExileRegistryType> map = new HashMap();
    public String id;
    ISerializable ser;
    int order;
    public SyncTime syncTime;
    public String modid;

    public ExileRegistryType(String modid, String id, int order, ISerializable ser, SyncTime synctime) {
        this.id = id;
        this.modid = modid;
        this.order = order;
        this.ser = ser;
        this.syncTime = synctime;
    }

    public static ExileRegistryType get(String id) {
        return map.get(id);
    }

    public static ExileRegistryType register(ExileRegistryType type) {
        all.add(type);
        map.put(type.id, type);
        return type;
    }

    public static ExileRegistryType register(String modid, String id, int order, ISerializable ser, SyncTime synctime) {
        ExileRegistryType type = new ExileRegistryType(modid, id, order, ser, synctime);
        return ExileRegistryType.register(type);
    }

    public static List<ExileRegistryType> getInRegisterOrder(SyncTime sync) {
        List<ExileRegistryType> list = all.stream().filter(x -> x.syncTime == sync).collect(Collectors.toList());
        list.sort(Comparator.comparingInt(x -> x.order));
        return list;
    }

    public static List<ExileRegistryType> getAllInRegisterOrder() {
        ArrayList<ExileRegistryType> list = new ArrayList<ExileRegistryType>(all);
        list.sort(Comparator.comparingInt(x -> x.order));
        return list;
    }

    public static void registerJsonListeners(SimpleReloadableResourceManager manager) {
        ArrayList<ExileRegistryType> list = new ArrayList<ExileRegistryType>(all);
        list.sort(Comparator.comparingInt(x -> x.order));
        list.forEach(x -> {
            if (x.getLoader() != null) {
                manager.func_219534_a((IFutureReloadListener)x.getLoader());
            }
        });
    }

    public static void init() {
    }

    public BaseDataPackLoader getLoader() {
        return new BaseDataPackLoader(this, this.id, x -> this.ser.fromJson((JsonObject)x)){

            @Override
            public ExileDatapackGenerator getDataPackGenerator() {
                return new ExileDatapackGenerator(ExileRegistryType.this.modid, ExileRegistryType.this.getAllForSerialization(), this.id);
            }
        };
    }

    public List getAllForSerialization() {
        return Database.getRegistry(this).getSerializable();
    }

    public final ISerializable getSerializer() {
        return this.ser;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj.hashCode() == this.hashCode();
    }
}

