/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.registry.loaders;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.robertx22.library_of_exile.main.LibraryOfExile;
import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileDatapackGenerator;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryContainer;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.utils.Watch;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public abstract class BaseDataPackLoader<T extends ExileRegistry>
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    public String id;
    Function<JsonObject, T> serializer;
    public ExileRegistryType registryType;
    static String ENABLED = "enabled";

    public BaseDataPackLoader(ExileRegistryType registryType, String id, Function<JsonObject, T> serializer) {
        super(GSON, id);
        Objects.requireNonNull(registryType);
        this.id = id;
        this.serializer = serializer;
        this.registryType = registryType;
    }

    public abstract ExileDatapackGenerator getDataPackGenerator();

    protected Map<ResourceLocation, JsonElement> func_212854_a_(IResourceManager manager, IProfiler profiler) {
        if (LibraryOfExile.runDevTools()) {
            this.getDataPackGenerator().run();
        }
        return super.func_212854_a_(manager, profiler);
    }

    protected void apply(Map<ResourceLocation, JsonElement> mapToLoad, IResourceManager manager, IProfiler profilerIn) {
        try {
            ExileRegistryContainer reg = Database.getRegistry(this.registryType);
            Watch normal = new Watch();
            normal.min = 50000;
            reg.unregisterAllEntriesFromDatapacks();
            mapToLoad.forEach((key, value) -> {
                try {
                    JsonObject json = value.getAsJsonObject();
                    if (!json.has(ENABLED) || json.get(ENABLED).getAsBoolean()) {
                        ExileRegistry object = (ExileRegistry)this.serializer.apply(json);
                        object.registerToExileRegistry();
                    }
                }
                catch (Exception exception) {
                    System.out.println(this.id + " is a broken datapack entry.");
                    exception.printStackTrace();
                }
            });
            normal.print("Loading " + this.registryType.id + " jsons ");
            if (reg.isEmpty()) {
                throw new RuntimeException("Exile Registry of type " + this.registryType.id + " is EMPTY after datapack loading!");
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }
}

