/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave;

import info.loenwind.autosave.Registry;
import info.loenwind.autosave.engine.StorableEngine;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.util.NBTAction;
import info.loenwind.autosave.util.NullHelper;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;

public class Reader {
    public static <T> void read(Registry registry, Set<NBTAction> phase, CompoundNBT tag, T object) {
        try {
            StorableEngine.read(registry, phase, tag, object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (NoHandlerFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void read(Set<NBTAction> phase, CompoundNBT tag, T object) {
        Reader.read(Registry.GLOBAL_REGISTRY, NullHelper.notnull(phase, "Missing phase"), NullHelper.notnull(tag, "Missing NBT"), object);
    }

    public static <T> void read(Registry registry, NBTAction phase, CompoundNBT tag, T object) {
        Reader.read(registry, (Set<NBTAction>)NullHelper.notnullJ(EnumSet.of(phase), "EnumSet.of()"), NullHelper.notnull(tag, "Missing NBT"), object);
    }

    public static <T> void read(NBTAction phase, CompoundNBT tag, T object) {
        Reader.read(Registry.GLOBAL_REGISTRY, (Set<NBTAction>)NullHelper.notnullJ(EnumSet.of(phase), "EnumSet.of()"), NullHelper.notnull(tag, "Missing NBT"), object);
    }

    public static <T> void read(Registry registry, CompoundNBT tag, T object) {
        Reader.read(registry, (Set<NBTAction>)NullHelper.notnullJ(EnumSet.allOf(NBTAction.class), "EnumSet.allOf()"), NullHelper.notnull(tag, "Missing NBT"), object);
    }

    public static <T> void read(CompoundNBT tag, T object) {
        Reader.read(Registry.GLOBAL_REGISTRY, (Set<NBTAction>)NullHelper.notnullJ(EnumSet.allOf(NBTAction.class), "EnumSet.allOf()"), NullHelper.notnull(tag, "Missing NBT"), object);
    }

    public static <T> T readField(CompoundNBT tag, Class<T> fieldClass, String fieldName, T object) {
        try {
            return StorableEngine.getSingleField(Registry.GLOBAL_REGISTRY, (Set<NBTAction>)NullHelper.notnullJ(EnumSet.allOf(NBTAction.class), "EnumSet.allOf()"), NullHelper.notnull(tag, "Missing NBT"), NullHelper.notnull(fieldName, "Missing field name"), NullHelper.notnull(fieldClass, "Missing field class"), object);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (NoHandlerFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

