/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.engine;

import com.google.common.base.Preconditions;
import info.loenwind.autosave.Registry;
import info.loenwind.autosave.annotations.AfterRead;
import info.loenwind.autosave.annotations.Factory;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import info.loenwind.autosave.handlers.internal.HandleStorable;
import info.loenwind.autosave.handlers.internal.NullHandler;
import info.loenwind.autosave.util.Log;
import info.loenwind.autosave.util.NBTAction;
import info.loenwind.autosave.util.NullHelper;
import info.loenwind.autosave.util.TypeUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;

public class StorableEngine {
    private static final ThreadLocal<StorableEngine> INSTANCE = new ThreadLocal<StorableEngine>(){

        @Override
        protected StorableEngine initialValue() {
            return new StorableEngine();
        }
    };
    public static final String NULL_POSTFIX = "-";
    public static final String EMPTY_POSTFIX = "+";
    public static final String SUPERCLASS_KEY = "__superclass";
    private final Map<Class<?>, List<Field>> fieldCache = new HashMap();
    private final Map<Field, Set<NBTAction>> phaseCache = new HashMap<Field, Set<NBTAction>>();
    private final Map<Field, List<IHandler>> fieldHandlerCache = new HashMap<Field, List<IHandler>>();
    private final Map<Class<?>, Class<?>> superclassCache = new HashMap();
    private final Map<Class<?>, List<IHandler>> superclassHandlerCache = new HashMap();
    private final Map<Class<?>, ObjectFactory> factoryCache = new HashMap();
    private final Map<Class<?>, List<AfterReadCallback>> callbackCache = new HashMap();

    private StorableEngine() {
    }

    public static <T> void read(Registry registry, Set<NBTAction> phase, CompoundNBT tag, T object) throws IllegalAccessException, InstantiationException, NoHandlerFoundException {
        INSTANCE.get().read_impl(registry, phase, tag, object);
    }

    public static <T> void store(Registry registry, Set<NBTAction> phase, CompoundNBT tag, T object) throws IllegalAccessException, InstantiationException, NoHandlerFoundException {
        INSTANCE.get().store_impl(registry, phase, tag, object);
    }

    public <T> void read_impl(Registry registry, Set<NBTAction> phase, CompoundNBT tag, T object) throws IllegalAccessException, InstantiationException, NoHandlerFoundException {
        Class<?> clazz = object.getClass();
        if (!this.fieldCache.containsKey(clazz)) {
            this.cacheHandlers(registry, clazz);
        }
        Log.livetraceNBT("Reading NBT data for object ", object, " of class ", clazz, " for phase(s) ", phase, " from NBT ", tag);
        block2: for (Field field : this.fieldCache.get(clazz)) {
            if (!Collections.disjoint((Collection)this.phaseCache.get(field), phase)) {
                Object fieldData = field.get(object);
                String fieldName = field.getName();
                if (!tag.func_74764_b(fieldName + NULL_POSTFIX) && fieldName != null) {
                    for (IHandler handler : this.fieldHandlerCache.get(field)) {
                        Log.livetraceNBT("Trying to read data for field ", fieldName, " with handler ", handler);
                        Object result = handler.read(registry, phase, tag, TypeUtil.getGenericType(field), fieldName, fieldData);
                        if (result == null) continue;
                        Log.livetraceNBT("Read data for field ", fieldName, " with handler ", handler, " yielded data: ", result);
                        field.set(object, result);
                        continue block2;
                    }
                    continue;
                }
                Log.livetraceNBT("Field ", fieldName, " is set to null. NULL_POSTFIX=", tag.func_74764_b(fieldName + NULL_POSTFIX));
                field.set(object, null);
                continue;
            }
            Log.livetraceNBT("Field ", field.getName(), " is not part of the current phase.");
        }
        Class<?> superclazz = this.superclassCache.get(clazz);
        if (superclazz != null) {
            for (IHandler handler : this.superclassHandlerCache.get(superclazz)) {
                Log.livetraceNBT("Trying to read data for super class ", superclazz, " with handler ", handler);
                if (handler.read(registry, phase, tag, superclazz, SUPERCLASS_KEY, object) == null) continue;
                Log.livetraceNBT("Read data for super class ", superclazz, " with handler ", handler);
                break;
            }
        }
        for (AfterReadCallback callback : this.callbackCache.get(clazz)) {
            try {
                callback.apply(object);
            }
            catch (IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException("Failed to invoke AfterRead: " + callback, e);
            }
        }
        Log.livetraceNBT("Read NBT data for object ", object, " of class ", clazz);
    }

    public <T> void store_impl(Registry registry, Set<NBTAction> phase, CompoundNBT tag, T object) throws IllegalAccessException, InstantiationException, NoHandlerFoundException {
        Class<?> clazz = object.getClass();
        if (!this.fieldCache.containsKey(clazz)) {
            this.cacheHandlers(registry, clazz);
        }
        Log.livetraceNBT("Saving NBT data for object ", object, " of class ", clazz, " for phase(s) ", phase, " into NBT ", tag);
        block0: for (Field field : this.fieldCache.get(clazz)) {
            if (!Collections.disjoint((Collection)this.phaseCache.get(field), phase)) {
                Object fieldData = field.get(object);
                String fieldName = field.getName();
                if (fieldData != null && fieldName != null) {
                    for (IHandler handler : this.fieldHandlerCache.get(field)) {
                        Log.livetraceNBT("Trying to save data for field ", fieldName, " with handler ", handler);
                        if (!handler.store(registry, phase, tag, TypeUtil.getGenericType(field), fieldName, fieldData)) continue;
                        Log.livetraceNBT("Saved data for field ", fieldName, " with handler ", handler, ". NBT now is ", tag);
                        continue block0;
                    }
                    continue;
                }
                Log.livetraceNBT("Field ", fieldName, " is null. Setting NULL_POSTFIX.");
                tag.func_74757_a(fieldName + NULL_POSTFIX, true);
                continue;
            }
            Log.livetraceNBT("Field ", field.getName(), " is not part of the current phase.");
        }
        Class<?> superclazz = this.superclassCache.get(clazz);
        if (superclazz != null) {
            for (IHandler handler : this.superclassHandlerCache.get(superclazz)) {
                Log.livetraceNBT("Trying to save data for super class ", superclazz, " with handler ", handler);
                if (!handler.store(registry, phase, tag, superclazz, SUPERCLASS_KEY, object)) continue;
                Log.livetraceNBT("Saved data for super class ", superclazz, " with handler ", handler);
                break;
            }
        }
        Log.livetraceNBT("Saved NBT data for object ", object, " of class ", clazz);
    }

    public static <T> T getSingleField(Registry registry, Set<NBTAction> phase, CompoundNBT tag, String fieldName, Type type, T object) throws InstantiationException, IllegalAccessException, IllegalArgumentException, NoHandlerFoundException {
        if (!tag.func_74764_b(fieldName + NULL_POSTFIX)) {
            for (IHandler handler : registry.findHandlers(type)) {
                T result = handler.read(registry, phase, tag, type, fieldName, object);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static <T> void setSingleField(Registry registry, Set<NBTAction> phase, CompoundNBT tag, String fieldName, Type fieldType, T fieldData) throws InstantiationException, IllegalAccessException, IllegalArgumentException, NoHandlerFoundException {
        if (fieldData != null) {
            tag.func_82580_o(fieldName + NULL_POSTFIX);
            for (IHandler handler : registry.findHandlers(fieldType)) {
                if (!handler.store(registry, phase, tag, fieldType, fieldName, fieldData)) continue;
                return;
            }
            throw new NoHandlerFoundException(fieldType, fieldName);
        }
        tag.func_82580_o(fieldName);
        tag.func_74757_a(fieldName + NULL_POSTFIX, true);
    }

    private void cacheHandlers(Registry registry, Class<?> clazz) throws IllegalAccessException, InstantiationException, NoHandlerFoundException {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            Store annotation = field.getAnnotation(Store.class);
            if (annotation == null) continue;
            ArrayList<IHandler> handlerList = new ArrayList<IHandler>();
            String fieldName = field.getName();
            if (fieldName == null) continue;
            Type fieldType = NullHelper.notnullJ(field.getGenericType(), "Field#getGenericType");
            Class<? extends IHandler> handlerClass = annotation.handler();
            if (handlerClass != NullHandler.class) {
                IHandler handler = handlerClass.newInstance().getHandler(registry, fieldType);
                if (handler != null) {
                    handlerList.add(handler);
                } else {
                    throw new NoHandlerFoundException("Handler specified in annotation on " + field + " does not apply to " + fieldType + ".");
                }
            }
            handlerList.addAll(registry.findHandlers(fieldType));
            if (handlerList.isEmpty()) {
                throw new NoHandlerFoundException(field, clazz);
            }
            EnumSet<NBTAction> enumSet = EnumSet.noneOf(NBTAction.class);
            enumSet.addAll(Arrays.asList(annotation.value()));
            this.phaseCache.put(field, enumSet);
            field.setAccessible(true);
            fieldList.add(field);
            this.fieldHandlerCache.put(field, handlerList);
        }
        AccessibleObject[] accessibleObjectArray = clazz.getDeclaredMethods();
        int n = accessibleObjectArray.length;
        for (int i = 0; i < n; ++i) {
            AccessibleObject method = accessibleObjectArray[i];
            if (!method.isAnnotationPresent(Factory.class)) continue;
            Preconditions.checkArgument((!this.factoryCache.containsKey(clazz) ? 1 : 0) != 0, (String)"Cannot have multiple factory methods on class", (Object)method);
            Preconditions.checkArgument((boolean)clazz.isAssignableFrom(((Method)method).getReturnType()), (String)"Factory method return type must be assignable to the owner type", (Object)method);
            Preconditions.checkArgument((((Method)method).getParameterCount() == 0 ? 1 : 0) != 0, (String)"Factory method cannot take parameters", (Object)method);
            ((Method)method).setAccessible(true);
            this.factoryCache.put(clazz, () -> StorableEngine.lambda$cacheHandlers$0((Method)method));
        }
        try {
            Constructor<?>[] ctor = clazz.getDeclaredConstructor(new Class[0]);
            int hasAnnotation = ctor.isAnnotationPresent(Factory.class) ? 1 : 0;
            if (Modifier.isPublic(ctor.getModifiers()) || hasAnnotation != 0) {
                if (!this.factoryCache.containsKey(clazz)) {
                    ctor.setAccessible(true);
                    this.factoryCache.put(clazz, () -> ctor.newInstance(new Object[0]));
                } else if (hasAnnotation != 0) {
                    throw new IllegalArgumentException("Cannot have a Factory constructor and a Factory method in the same class (" + clazz + ")");
                }
            }
        }
        catch (NoSuchMethodException | SecurityException ctor) {
            // empty catch block
        }
        for (Constructor<?> ctor : clazz.getDeclaredConstructors()) {
            if (!ctor.isAnnotationPresent(Factory.class)) continue;
            Preconditions.checkArgument((ctor.getParameterCount() == 0 ? 1 : 0) != 0, (String)"Factory constructor cannot take parameters", ctor);
        }
        Class<?> superclazz = clazz.getSuperclass();
        if (superclazz != null) {
            Storable annotation = superclazz.getAnnotation(Storable.class);
            if (annotation != null) {
                if (annotation.handler() == HandleStorable.class) {
                    this.cacheHandlers(registry, superclazz);
                    fieldList.addAll((Collection)this.fieldCache.get(superclazz));
                } else {
                    this.superclassCache.put(clazz, superclazz);
                    if (!this.superclassCache.containsKey(superclazz)) {
                        this.superclassHandlerCache.put(superclazz, Arrays.asList(annotation.handler().newInstance()));
                    }
                }
            } else {
                List<IHandler> handlers = registry.findHandlers(superclazz);
                if (!handlers.isEmpty()) {
                    this.superclassCache.put(clazz, superclazz);
                    if (!this.superclassCache.containsKey(superclazz)) {
                        this.superclassHandlerCache.put(superclazz, handlers);
                    }
                }
            }
        }
        ArrayList<AfterReadCallback> callbacks = new ArrayList<AfterReadCallback>();
        for (Method m : clazz.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(AfterRead.class)) continue;
            callbacks.add(new AfterReadCallback(m));
        }
        this.callbackCache.put(clazz, callbacks);
        this.fieldCache.put(clazz, fieldList);
    }

    public Object instantiate_impl(Registry registry, Type type) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        Class<?> clazz = TypeUtil.toClass(type);
        if (!this.fieldCache.containsKey(clazz)) {
            this.cacheHandlers(registry, clazz);
        }
        if (this.factoryCache.containsKey(clazz)) {
            ObjectFactory factory = this.factoryCache.get(clazz);
            try {
                Object result = factory.get();
                Preconditions.checkNotNull((Object)result, (String)"Factory methods cannot return null", clazz);
                return result;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException("Failed to invoke factory method or constructor on " + clazz, e);
            }
        }
        throw new IllegalArgumentException("No factory found for " + clazz);
    }

    public static <T> T instantiate(Registry registry, Type type) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        return (T)INSTANCE.get().instantiate_impl(registry, type);
    }

    private static /* synthetic */ Object lambda$cacheHandlers$0(Method method) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return method.invoke(null, new Object[0]);
    }

    private static class AfterReadCallback {
        private final Method callback;
        private final boolean isStatic;

        AfterReadCallback(Method m) throws IllegalArgumentException {
            Preconditions.checkArgument((m.getReturnType() == Void.TYPE ? 1 : 0) != 0, (String)"AfterRead methods cannot return a value", (Object)m);
            Preconditions.checkArgument((m.getParameterCount() == 0 ? 1 : 0) != 0, (String)"AfterRead methods cannot take parameters", (Object)m);
            m.setAccessible(true);
            this.callback = m;
            this.isStatic = Modifier.isStatic(m.getModifiers());
        }

        public void apply(Object inst) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.callback.invoke(this.isStatic ? null : inst, new Object[0]);
        }

        public String toString() {
            return NullHelper.notnullJ(this.callback.toString(), "Method#toString");
        }
    }

    @FunctionalInterface
    private static interface ObjectFactory {
        public Object get() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException;
    }
}

