/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.java.util;

import info.loenwind.autosave.Registry;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import info.loenwind.autosave.handlers.util.HandleGenericType;
import info.loenwind.autosave.util.NBTAction;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public abstract class HandleCollection<T extends Collection>
extends HandleGenericType<T> {
    public HandleCollection(Class<? extends T> clazz) throws NoHandlerFoundException {
        this(clazz, Registry.GLOBAL_REGISTRY, new Type[0]);
    }

    protected HandleCollection(Class<? extends T> clazz, Registry registry, Type ... types) throws NoHandlerFoundException {
        super(clazz, registry, types);
    }

    @Override
    public boolean store(Registry registry, Set<NBTAction> phase, CompoundNBT nbt, Type type, String name, T object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("size", object.size());
        int i = 0;
        for (Object elem : object) {
            if (elem != null) {
                for (IHandler handler : this.subHandlers[0]) {
                    handler.store(registry, phase, tag, type, i + "", elem);
                }
            }
            ++i;
        }
        nbt.func_218657_a(name, (INBT)tag);
        return true;
    }

    @Override
    public T read(Registry registry, Set<NBTAction> phase, CompoundNBT nbt, Type type, String name, T object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if (nbt.func_74764_b(name)) {
            if (object == null) {
                object = this.makeCollection();
            } else {
                object.clear();
            }
            CompoundNBT tag = nbt.func_74775_l(name);
            int size = tag.func_74762_e("size");
            for (int i = 0; i < size; ++i) {
                object.add(this.readRecursive(0, registry, phase, tag, i + "", null));
            }
        }
        return object;
    }

    protected abstract T makeCollection();
}

