/*
 * Decompiled with CFR 0.152.
 */
package nmd.nethersheep.blocks;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import nmd.nethersheep.helpers.CommonUtils;
import nmd.nethersheep.helpers.FXHelper;
import nmd.nethersheep.init.BlockRegistry;
import nmd.nethersheep.init.RegistryHelper;

public class AtreWool
extends FallingBlock {
    protected static final BlockBehaviour.Properties ATRE_WOOL = BlockBehaviour.Properties.m_60944_((Material)Material.f_76272_, (MaterialColor)MaterialColor.f_76365_).m_60918_(SoundType.f_56745_).m_60913_(0.85f, 2.0f).m_60911_(0.8f).m_60922_(RegistryHelper::never);
    protected static final VoxelShape ATRE_WOOL_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape ATRE_CARPET_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public AtreWool() {
        this(ATRE_WOOL);
    }

    public AtreWool(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.tryAbsorbWater(world, pos);
        super.m_6807_(state, world, pos, oldState, isMoving);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (CommonUtils.randomCheck(6, level.m_213780_())) {
            this.tryAbsorbWater(level, pos);
        }
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
    }

    protected void tryAbsorbWater(Level world, BlockPos pos) {
        if (this.removeWaterBreadthFirstSearch(world, pos)) {
            FXHelper.fxLava((LevelAccessor)world, pos, true, 0);
            world.m_7731_(pos, ((Block)BlockRegistry.ATRE_WOOL_WET.get()).m_49966_(), 2);
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)Blocks.f_49990_.m_49966_()));
        }
    }

    protected boolean removeWaterBreadthFirstSearch(Level world, BlockPos pos) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)pos, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.m_14418_();
            int j = (Integer)tuple.m_14419_();
            for (Direction direction : Direction.values()) {
                BlockPos blockpos1 = blockpos.m_121945_(direction);
                BlockState blockstate = world.m_8055_(blockpos1);
                FluidState fluidstate = world.m_6425_(blockpos1);
                Material material = blockstate.m_60767_();
                if (!fluidstate.m_205070_(FluidTags.f_13131_)) continue;
                if (blockstate.m_60734_() instanceof BucketPickup && !((BucketPickup)blockstate.m_60734_()).m_142598_((LevelAccessor)world, blockpos1, blockstate).m_41619_()) {
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (blockstate.m_60734_() instanceof LiquidBlock) {
                    FXHelper.fxLava((LevelAccessor)world, blockpos1, false, 16);
                    world.m_7731_(blockpos1, Blocks.f_50016_.m_49966_(), 3);
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (material != Material.f_76301_ && material != Material.f_76304_) continue;
                BlockEntity blockentity = blockstate.m_155947_() ? world.m_7702_(blockpos1) : null;
                AtreWool.m_49892_((BlockState)blockstate, (LevelAccessor)world, (BlockPos)blockpos1, (BlockEntity)blockentity);
                FXHelper.fxLava((LevelAccessor)world, blockpos1, false, 16);
                world.m_7731_(blockpos1, Blocks.f_50016_.m_49966_(), 3);
                ++i;
                if (j >= 6) continue;
                queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
        return i > 0;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (entity.m_20162_()) {
            super.m_142072_(level, state, pos, entity, fallDistance);
        } else {
            entity.m_142535_(fallDistance, 0.0f, level.m_269111_().m_268989_());
        }
    }

    public void m_5548_(BlockGetter level, Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(level, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        double d = Math.abs(entity.m_20184_().f_82480_);
        if (d < 0.1 && !entity.m_20161_()) {
            double e = 0.4 + d * 0.2;
            entity.m_20256_(entity.m_20184_().m_82542_(e, 1.0, e));
        }
        super.m_141947_(level, pos, state, entity);
    }

    private void bounceUp(Entity entity) {
        Vec3 vec3 = entity.m_20184_();
        if (vec3.f_82480_ < 0.0) {
            double d = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(vec3.f_82479_, -vec3.f_82480_ * d, vec3.f_82481_);
        }
    }

    public int m_6248_(BlockState state, BlockGetter reader, BlockPos pos) {
        return 14406560;
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 0.2f;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ATRE_WOOL_SHAPE;
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        super.m_214162_(state, world, pos, rand);
        if (world.m_46758_(pos.m_7494_())) {
            FXHelper.makeParticles(world, pos, (ParticleOptions)ParticleTypes.f_123755_, 1, 4, (double)1.1f, 0.0, 0.0, 0.0);
        }
    }
}

