/*
 * Decompiled with CFR 0.152.
 */
package nmd.nethersheep.entities.ai;

import com.google.common.base.Predicate;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import nmd.nethersheep.entities.living.Atre;
import nmd.nethersheep.helpers.CommonUtils;
import nmd.nethersheep.helpers.FXHelper;
import nmd.nethersheep.helpers.ItemHelper;

public class EatItem
extends Goal {
    protected final float EAT_DISTANCE = 2.06f;
    protected final Predicate<Entity> canBeSeenSelector;
    protected final Atre entity;
    protected final double speed;
    protected final double distance;
    protected ItemEntity target;
    protected boolean isRunning;
    protected boolean isFood;

    public EatItem(Atre entity, double speed) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.entity = entity;
        this.speed = speed;
        this.distance = 12.0;
        this.canBeSeenSelector = entity1 -> entity1 != null && entity1.m_6084_() && this.entity.m_21574_().m_148306_(entity1) && !this.entity.m_7307_((Entity)entity1);
        if (!(entity.m_21573_() instanceof GroundPathNavigation)) {
            throw new IllegalArgumentException("Wrong EntityType for EatItem Goal");
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private void continueTask() {
        this.entity.m_21573_().m_26573_();
        this.target = null;
        this.isRunning = true;
    }

    public boolean m_8045_() {
        return !this.entity.m_21573_().m_26571_() && this.target.m_6084_() && this.target.m_20280_((Entity)this.entity) < this.distance * this.distance;
    }

    public void m_8056_() {
        this.isRunning = true;
    }

    public void m_8041_() {
        this.entity.m_21573_().m_26573_();
        this.target = null;
        this.isRunning = false;
        this.isFood = false;
    }

    public boolean m_8036_() {
        if (!this.entity.isPuking() && this.entity.canEatFood() && CommonUtils.randomCheck(6, this.entity.m_217043_())) {
            List list = this.entity.f_19853_.m_6443_(ItemEntity.class, this.entity.m_20191_().m_82377_(8.0, 4.0, 8.0), this.canBeSeenSelector);
            for (ItemEntity entityItem : list) {
                ItemStack stack = entityItem.m_32055_();
                if (this.entity.m_6898_(stack) && this.entity.m_5957_()) {
                    this.target = entityItem;
                    this.isFood = true;
                    return true;
                }
                if (!this.entity.isStomachItem(stack)) continue;
                this.target = entityItem;
                this.isFood = false;
                return true;
            }
        }
        return false;
    }

    public void m_8037_() {
        this.entity.m_21563_().m_24960_((Entity)this.target, (float)(this.entity.m_8085_() + 20), (float)this.entity.m_8132_());
        if (this.entity.m_20280_((Entity)this.target) <= (double)2.06f) {
            this.entity.m_21573_().m_26573_();
            if (!this.eatItem(this.target)) {
                this.continueTask();
            }
        } else {
            this.entity.m_21573_().m_5624_((Entity)this.target, this.speed);
            if (!this.target.m_6084_()) {
                this.continueTask();
            }
        }
    }

    protected boolean eatItem(ItemEntity target) {
        ItemStack stack = target.m_32055_();
        if (!stack.m_41619_()) {
            float nutrition = ItemHelper.getFoodNutrition(stack);
            if (this.isFood) {
                FXHelper.playSound((LevelAccessor)this.entity.f_19853_, this.entity.m_20183_(), this.entity.m_7866_(stack));
                ItemHelper.takeOneItem(target);
                this.entity.m_5634_(nutrition);
                this.entity.m_8035_();
                if (this.entity.m_5957_() && !this.entity.m_6162_()) {
                    this.entity.m_27595_(null);
                }
                if (this.entity.m_5448_() instanceof Player) {
                    this.entity.m_6710_(null);
                    this.entity.m_6925_(null);
                    this.entity.m_7870_(0);
                }
            } else {
                FXHelper.playSound((LevelAccessor)this.entity.f_19853_, this.entity.m_20183_(), this.entity.m_7866_(stack));
                ItemStack leftovers = this.entity.m_35311_().m_19173_(stack);
                if (leftovers.m_41619_()) {
                    this.target.m_6074_();
                } else {
                    this.target.m_32045_(leftovers);
                }
            }
            return true;
        }
        return false;
    }
}

