/*
 * Decompiled with CFR 0.152.
 */
package nmd.nethersheep.helpers;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import nmd.nethersheep.Nethersheep;
import nmd.nethersheep.helpers.CommonUtils;

public class FXHelper {
    public static void playSound(LevelAccessor level, BlockPos pos, SoundEvent sound, SoundSource category, float volume, float pitch) {
        level.m_5594_(null, pos, sound, category, volume, pitch);
    }

    public static void playSound(LevelAccessor level, BlockPos pos, SoundEvent sound, SoundSource category, float volume) {
        level.m_5594_(null, pos, sound, category, volume, level.m_213780_().m_188501_() * 0.4f + 0.8f);
    }

    public static void playSound(LevelAccessor level, BlockPos pos, SoundEvent sound, float volume) {
        FXHelper.playSound(level, pos, sound, SoundSource.BLOCKS, volume);
    }

    public static void playSound(LevelAccessor level, BlockPos pos, SoundEvent sound) {
        FXHelper.playSound(level, pos, sound, SoundSource.BLOCKS, 1.0f);
    }

    public static void soundFireAmbient(LevelAccessor level, BlockPos pos, float volume) {
        FXHelper.playSound(level, pos, SoundEvents.f_11936_, volume);
    }

    public static void soundFireExtinguish(LevelAccessor level, BlockPos pos, float volume) {
        FXHelper.playSound(level, pos, SoundEvents.f_11937_, volume);
    }

    public static void makeParticles(Level world, BlockPos pos, ParticleOptions particles, int amount, int interval, double offsetY, double speedX, double speedY, double speedZ) {
        if (CommonUtils.randomCheck(interval, world.m_213780_())) {
            for (int i = 0; i <= amount; ++i) {
                world.m_7106_(particles, (double)((float)pos.m_123341_() + world.f_46441_.m_188501_()), (double)pos.m_123342_() + offsetY, (double)((float)pos.m_123343_() + world.f_46441_.m_188501_()), speedX, speedY, speedZ);
            }
        }
    }

    public static void makeParticles(ServerLevel world, BlockPos pos, ParticleOptions particles, int amount, int interval, double xOffset, double yOffset, double zOffset, double particleSpeed) {
        if (CommonUtils.randomCheck(interval, world.m_213780_())) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            for (int i = 0; i <= amount; ++i) {
                world.m_8767_(particles, (double)pos.m_123341_() + random.nextDouble(0.2, 0.6), (double)pos.m_123342_() + yOffset, (double)pos.m_123343_() + random.nextDouble(0.2, 0.6), 1, xOffset, yOffset, zOffset, particleSpeed);
            }
        }
    }

    public static void drawParticleTrail(ParticleOptions particles, Entity entity, BlockPos destination) {
        Level world = entity.m_20193_();
        if (!world.f_46443_) {
            double x = destination.m_123341_();
            double y = destination.m_123342_();
            double z = destination.m_123343_();
            for (int j = 0; j < 128; ++j) {
                double d6 = (double)j / 127.0;
                float f0 = (world.f_46441_.m_188501_() - 0.5f) * 0.2f;
                float f1 = (world.f_46441_.m_188501_() - 0.5f) * 0.2f;
                float f2 = (world.f_46441_.m_188501_() - 0.5f) * 0.2f;
                double d3 = x + (entity.m_20185_() - x) * d6 + (world.f_46441_.m_188500_() - 0.5) * (double)entity.m_20205_() * 2.0;
                double d4 = y + (entity.m_20186_() - y) * d6 + world.f_46441_.m_188500_() * (double)entity.m_20206_();
                double d5 = z + (entity.m_20189_() - z) * d6 + (world.f_46441_.m_188500_() - 0.5) * (double)entity.m_20205_() * 2.0;
                ((ServerLevel)world).m_8767_(particles, d3, d4, d5, 1, (double)f0, (double)f1, (double)f2, 0.0);
            }
        }
    }

    public static void drawParticleTrail(ParticleOptions particles, Level level, BlockPos origin, BlockPos destination) {
        if (!level.f_46443_) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            double x = destination.m_123341_();
            double y = destination.m_123342_();
            double z = destination.m_123343_();
            for (int j = 0; j < 128; ++j) {
                double d6 = (double)j / 127.0;
                float f0 = (random.nextFloat() - 0.5f) * 0.2f;
                float f1 = (random.nextFloat() - 0.5f) * 0.2f;
                float f2 = (random.nextFloat() - 0.5f) * 0.2f;
                double d3 = x + ((double)origin.m_123341_() - x) * d6 + (random.nextDouble() - 0.5) * random.nextDouble(0.2, 0.6) * 2.0;
                double d4 = y + ((double)origin.m_123342_() - y) * d6 + random.nextDouble() * random.nextDouble(0.2, 0.6);
                double d5 = z + ((double)origin.m_123343_() - z) * d6 + (random.nextDouble() - 0.5) * random.nextDouble(0.2, 0.6) * 2.0;
                ((ServerLevel)level).m_8767_(particles, d3, d4, d5, 1, (double)f0, (double)f1, (double)f2, 0.0);
            }
        }
    }

    public static void fxLava(LevelAccessor world, BlockPos pos, boolean sound, int chance) {
        if (CommonUtils.randomCheck(chance, world.m_213780_()) && !world.m_5776_()) {
            if (sound) {
                FXHelper.soundFireExtinguish(world, pos, 1.0f);
            }
            FXHelper.makeParticles((ServerLevel)world, pos, (ParticleOptions)ParticleTypes.f_123755_, Nethersheep.RANDOM.m_216339_(4, 8), 0, 0.0, (double)0.9f, 0.0, 0.0);
        }
    }

    public static void fxSmokeParticles(Level level, double x, double y, double z) {
        FXHelper.fxSmokeParticles(level, BlockPos.m_274561_((double)x, (double)y, (double)z));
    }

    public static void fxSmokeParticles(Level level, Vec3 pos) {
        for (int i = 0; i < 3; ++i) {
            double d0 = pos.m_7096_() + level.f_46441_.m_188500_();
            double d1 = pos.m_7098_() + level.f_46441_.m_188500_() * 0.5 + 0.5;
            double d2 = pos.m_7094_() + level.f_46441_.m_188500_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static void fxSmokeParticles(Level level, BlockPos pos) {
        for (int i = 0; i < 3; ++i) {
            double d0 = (double)pos.m_123341_() + level.f_46441_.m_188500_();
            double d1 = (double)pos.m_123342_() + level.f_46441_.m_188500_() * 0.5 + 0.5;
            double d2 = (double)pos.m_123343_() + level.f_46441_.m_188500_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }
}

