/*
 * Decompiled with CFR 0.152.
 */
package nmd.nethersheep.client.models;

import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nmd.nethersheep.entities.living.Atre;

@OnlyIn(value=Dist.CLIENT)
public class AtreModel<T extends Atre>
extends QuadrupedModel<T> {
    private float headXRot;

    public AtreModel(ModelPart modelPart) {
        super(modelPart, false, 8.0f, 4.0f, 2.0f, 2.0f, 24);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = QuadrupedModel.m_170864_((int)12, (CubeDeformation)CubeDeformation.f_171458_);
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -4.0f, -6.0f, 6.0f, 6.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)-8.0f));
        partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(28, 8).m_171481_(-4.0f, -10.0f, -7.0f, 8.0f, 16.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_(entity, limbSwing, limbSwingAmount, partialTick);
        this.f_103492_.f_104201_ = 6.0f + ((Atre)entity).getHeadEatPositionScale(partialTick) * 9.0f;
        this.headXRot = ((Atre)entity).getHeadEatAngleScale(partialTick);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.f_103492_.f_104203_ = this.headXRot;
    }
}

