/*
 * Decompiled with CFR 0.152.
 */
package nmd.nethersheep.entities.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class TempByFood
extends Goal {
    private static final TargetingConditions TEMP_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0);
    private Player closestPlayer;
    private final Animal animal;
    private final boolean scaredByPlayerMovement;
    private final double speed;
    private double targetX;
    private double targetY;
    private double targetZ;
    private double pitch;
    private double yaw;
    private int delayTemptCounter;
    private boolean isRunning;

    public TempByFood(Animal animal, double speedIn, boolean scared_by_movement) {
        this.animal = animal;
        this.speed = speedIn;
        this.scaredByPlayerMovement = scared_by_movement;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(animal.m_21573_() instanceof GroundPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob TYPE for TemptGoal");
        }
    }

    public boolean m_8036_() {
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.closestPlayer = this.animal.f_19853_.m_45946_(TEMP_TARGETING, (LivingEntity)this.animal);
        if (this.closestPlayer == null) {
            return false;
        }
        return this.isTempting(this.closestPlayer.m_21205_()) || this.isTempting(this.closestPlayer.m_21206_());
    }

    protected boolean isTempting(ItemStack stack) {
        return stack != null && !stack.m_41619_() && this.animal.m_6898_(stack);
    }

    public boolean m_8045_() {
        if (this.isScaredByPlayerMovement()) {
            if (this.animal.m_20280_((Entity)this.closestPlayer) < 36.0) {
                if (this.closestPlayer.m_20275_(this.targetX, this.targetY, this.targetZ) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.closestPlayer.m_146909_() - this.pitch) > 5.0 || Math.abs((double)this.closestPlayer.m_146908_() - this.yaw) > 5.0) {
                    return false;
                }
            } else {
                this.targetX = this.closestPlayer.m_20185_();
                this.targetY = this.closestPlayer.m_20186_();
                this.targetZ = this.closestPlayer.m_20189_();
            }
            this.pitch = this.closestPlayer.m_146909_();
            this.yaw = this.closestPlayer.m_146908_();
        }
        return this.m_8036_();
    }

    protected boolean isScaredByPlayerMovement() {
        return this.scaredByPlayerMovement;
    }

    public void m_8056_() {
        this.targetX = this.closestPlayer.m_20185_();
        this.targetY = this.closestPlayer.m_20186_();
        this.targetZ = this.closestPlayer.m_20189_();
        this.isRunning = true;
    }

    public void m_8041_() {
        this.closestPlayer = null;
        this.animal.m_21573_().m_26573_();
        this.delayTemptCounter = 100;
        this.isRunning = false;
    }

    public void m_8037_() {
        this.animal.m_21563_().m_24960_((Entity)this.closestPlayer, (float)(this.animal.m_8085_() + 20), (float)this.animal.m_8132_());
        if (this.animal.m_20280_((Entity)this.closestPlayer) < 6.25) {
            this.animal.m_21573_().m_26573_();
        } else {
            this.animal.m_21573_().m_5624_((Entity)this.closestPlayer, this.speed);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

