/*
 * Decompiled with CFR 0.152.
 */
package nmd.nethersheep.entities.living;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import nmd.nethersheep.entities.ai.EatItem;
import nmd.nethersheep.entities.ai.EatPlant;
import nmd.nethersheep.entities.ai.FleeRain;
import nmd.nethersheep.entities.ai.RestrictRain;
import nmd.nethersheep.entities.ai.TempByFood;
import nmd.nethersheep.entities.living.IHerbavoir;
import nmd.nethersheep.helpers.CommonUtils;
import nmd.nethersheep.helpers.DamagePredicate;
import nmd.nethersheep.helpers.FXHelper;
import nmd.nethersheep.helpers.ItemHelper;
import nmd.nethersheep.helpers.TeleportHelper;
import nmd.nethersheep.init.BlockRegistry;
import nmd.nethersheep.init.EntityRegistry;
import nmd.nethersheep.init.ItemRegistry;
import nmd.nethersheep.init.LootRegistry;
import nmd.nethersheep.init.SoundRegistry;
import nmd.nethersheep.tags.ModBlockTags;
import nmd.nethersheep.tags.ModEntityTags;
import nmd.nethersheep.tags.ModItemTags;
import org.jetbrains.annotations.Nullable;

public class Atre
extends Animal
implements InventoryCarrier,
Shearable,
IHerbavoir {
    private static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(Atre.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(Atre.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.m_135353_(Atre.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NATIVE = SynchedEntityData.m_135353_(Atre.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> MILK = SynchedEntityData.m_135353_(Atre.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final Predicate<DamageSource> DAMAGE_IMMUNITY = DamagePredicate.forDamage(DamageSource.f_19320_, DamageSource.f_19315_, DamageSource.f_19314_, DamageSource.f_19325_);
    private static final Map<Block, Block> SOIL_SAMPLES = new HashMap<Block, Block>(){
        {
            this.put(Blocks.f_50699_, Blocks.f_50699_);
            this.put(Blocks.f_50690_, Blocks.f_50690_);
            this.put(Blocks.f_50195_, Blocks.f_50195_);
        }
    };
    private static final Predicate<LivingEntity> NON_TARGET = target -> target.m_5789_() && !target.m_6162_() && !target.m_6095_().m_204039_(ModEntityTags.ATRE_ATTACK_BLACKLIST);
    private EatPlant eatPlants;
    private int eatAnimationTick;
    private int angryTimer;
    private static final int CONTAINER_SIZE = 27;
    private static final int WOOL_DROP = 1;
    private final SimpleContainer stomach = new SimpleContainer(27);
    private int pukeTimer;

    public Atre(EntityType<? extends Atre> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.setFullMilk();
    }

    public ResourceLocation m_7582_() {
        return this.isSheared() ? LootRegistry.ATRE_DEFAULT_LOOT : LootRegistry.ATRE_WOOL_LOOT;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(this.m_21223_()));
        this.f_19804_.m_135372_(SHEARED, (Object)false);
        this.f_19804_.m_135372_(ANGRY, (Object)false);
        this.f_19804_.m_135372_(NATIVE, (Object)this.isWorldNative());
        this.f_19804_.m_135372_(MILK, (Object)4);
    }

    public static AttributeSupplier.Builder createLivingAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22278_, 0.2).m_22268_(Attributes.f_22279_, 0.245).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22285_, 0.0).m_22268_(Attributes.f_22281_, 3.0).m_22266_(Attributes.f_22282_).m_22268_(Attributes.f_22277_, 16.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AttackGoal(this, 1.2, false));
        this.f_21346_.m_25352_(1, (Goal)new RevengeTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, new AttackTarget<Animal>(this, Animal.class, 40));
        this.f_21346_.m_25352_(2, new AttackTarget<Spider>(this, Spider.class, 40));
        this.f_21346_.m_25352_(2, new AttackTarget<Zombie>(this, Zombie.class, 60));
        this.f_21346_.m_25352_(2, new AttackTarget<Zoglin>(this, Zoglin.class, 60));
        this.f_21346_.m_25352_(2, new AttackTarget<EnderMan>(this, EnderMan.class, 30));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Llama.class, 12.0f, 1.1, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Creeper.class, 12.0f, 1.1, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, WitherSkeleton.class, 12.0f, 1.1, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Drowned.class, 12.0f, 1.1, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new FleeRain((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new RestrictRain((PathfinderMob)this));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.eatPlants = new EatPlant((Mob)this, ModBlockTags.ATRE_PLANTS, SOIL_SAMPLES);
        this.f_21345_.m_25352_(9, (Goal)this.eatPlants);
        this.f_21345_.m_25352_(8, (Goal)new TempByFood(this, 1.15, false));
        this.f_21345_.m_25352_(7, (Goal)new AtreEatItem(this, 1.2, ModItemTags.ATRE_STOMACH_ITEMS));
        this.f_21345_.m_25352_(12, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(13, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    protected void m_8024_() {
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(this.m_21223_()));
        this.eatAnimationTick = this.eatPlants.getEatAnimationTick();
        super.m_8024_();
    }

    public boolean m_6779_(LivingEntity target) {
        return target.m_6095_() != this.m_6095_() && super.m_6779_(target);
    }

    public void m_8107_() {
        Level world = this.m_20193_();
        BlockPos pos = this.m_142538_();
        if (world.f_46443_) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
            if (!this.isSheared() && this.m_20070_()) {
                FXHelper.makeParticles(world, pos, (ParticleOptions)ParticleTypes.f_123755_, 1, 8, (double)1.1f, 0.0, 0.0, 0.0);
                FXHelper.fxSmokeParticles(world, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_());
            }
        } else {
            if (this.isAngry()) {
                if (this.m_5448_() == null || this.angryTimer == 0) {
                    this.setAngry(false);
                    this.angryTimer = 0;
                } else {
                    this.angryTimer = Math.max(0, this.angryTimer - 1);
                }
            }
            if (this.isPuking()) {
                --this.pukeTimer;
                if (CommonUtils.randomCheck(60, this.m_21187_())) {
                    this.puke();
                }
            }
        }
        super.m_8107_();
    }

    public boolean m_6573_(Player player) {
        return !this.isAngry() && super.m_6573_(player);
    }

    public void m_6710_(LivingEntity target) {
        super.m_6710_(target);
        if (target == null) {
            this.setAngry(false);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (DAMAGE_IMMUNITY.test(source)) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (entity != null && !(entity instanceof Player) && !(entity instanceof Arrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return this.onAttackDamage(source, amount) && super.m_6469_(source, amount);
    }

    protected boolean onAttackDamage(DamageSource source, float amount) {
        if (this.canTeleport() && CommonUtils.randomCheck(3, this.m_21187_())) {
            return !TeleportHelper.teleportRandomly((LivingEntity)this, 64, 64, true);
        }
        if (ItemHelper.hasMatching((Container)this.getInventory(), ModItemTags.ATRE_STOMACH_REGENERATION)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19614_, CommonUtils.getDamageEffectStrength((LivingEntity)this) * 20));
        }
        return true;
    }

    public boolean m_7327_(Entity entity) {
        boolean flag = super.m_7327_(entity);
        if (flag && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            float modifier = this.f_19853_.m_6436_(this.m_142538_()).m_19056_();
            if (ItemHelper.hasMatching((Container)this.getInventory(), ModItemTags.ATRE_STOMACH_FIRE) && this.f_19796_.nextFloat() < modifier * 0.3f) {
                living.m_20254_(4 * (int)modifier);
            }
            if (ItemHelper.hasMatching((Container)this.getInventory(), ModItemTags.ATRE_STOMACH_POISON) && this.f_19796_.nextFloat() < modifier * 0.3f) {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19614_, CommonUtils.getDamageEffectStrength(living) * 20));
            }
            if (ItemHelper.hasMatching((Container)this.getInventory(), ModItemTags.ATRE_STOMACH_WITHER) && this.f_19796_.nextFloat() < modifier * 0.3f) {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19615_, CommonUtils.getDamageEffectStrength(living) * 20));
            }
        }
        return flag;
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        if (CommonUtils.isEffectPoisonous(effectInstance)) {
            return false;
        }
        return super.m_7301_(effectInstance);
    }

    public void m_7601_(BlockState state, Vec3 vec) {
        if (state.m_60734_() != Blocks.f_50033_) {
            super.m_7601_(state, vec);
        }
    }

    public void m_6667_(DamageSource cause) {
        if (ItemHelper.hasMatching((Container)this.getInventory(), ModItemTags.ATRE_STOMACH_IMMORTALITY)) {
            FXHelper.playSound((LevelAccessor)this.f_19853_, this.m_142538_(), SoundEvents.f_12513_, 1.0f);
            this.m_21153_(1.0f);
            this.m_21219_();
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
            this.f_19853_.m_7605_((Entity)this, (byte)35);
        } else {
            super.m_6667_(cause);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        ItemStack milkStack = this.getMilkBottle();
        if (!heldStack.m_41619_()) {
            if (this.canMilk() && heldStack.m_150930_(Items.f_42590_)) {
                player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
                ItemStack filledBottle = ItemUtils.m_41813_((ItemStack)heldStack, (Player)player, (ItemStack)milkStack);
                player.m_21008_(hand, filledBottle);
                this.takeMilk();
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (heldStack.m_150930_(Items.f_42574_)) {
                if (!this.f_19853_.f_46443_ && this.m_6220_()) {
                    this.m_5851_(SoundSource.PLAYERS);
                    this.m_146852_(GameEvent.f_157781_, (Entity)player);
                    heldStack.m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(hand));
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
            if (this.m_6898_(heldStack)) {
                int i = this.m_146764_();
                if (!this.f_19853_.f_46443_ && i == 0 && this.m_5957_()) {
                    this.m_142075_(player, hand, heldStack);
                    this.m_27595_(player);
                    this.m_8035_();
                    return InteractionResult.SUCCESS;
                }
                if (this.m_6162_()) {
                    this.m_142075_(player, hand, heldStack);
                    this.m_146740_((int)((float)(-i / 20) * 0.1f), true);
                    this.m_146859_(GameEvent.f_157771_, this.m_146901_());
                    return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                }
                if (this.f_19853_.f_46443_) {
                    return InteractionResult.CONSUME;
                }
            }
            if (this.feedEmetic(player, hand, heldStack)) {
                return InteractionResult.SUCCESS;
            }
            if (this.feedItem(player, hand, heldStack)) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_5851_(SoundSource source) {
        this.f_19853_.m_6269_((Player)null, (Entity)this, SoundEvents.f_12344_, source, 1.0f, 1.0f);
        this.setSheared(true);
        for (int j = 0; j < 1; ++j) {
            ItemEntity itemEntity = this.m_5552_(this.getWool(), 1.0f);
            if (itemEntity == null) continue;
            itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.1f), (double)(this.f_19796_.nextFloat() * 0.05f), (double)((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.1f)));
        }
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.isSheared() && !this.m_6162_();
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public ItemStack getWool() {
        return new ItemStack((ItemLike)BlockRegistry.ATRE_WOOL.get());
    }

    public void setAngry(boolean value) {
        this.f_19804_.m_135381_(ANGRY, (Object)(value && !this.m_6162_() ? 1 : 0));
    }

    public boolean isAngry() {
        return (Boolean)this.f_19804_.m_135370_(ANGRY);
    }

    public void setNative(boolean value) {
        this.f_19804_.m_135381_(NATIVE, (Object)value);
    }

    public boolean isNative() {
        return (Boolean)this.f_19804_.m_135370_(NATIVE);
    }

    public boolean isWorldNative() {
        return CommonUtils.isNetherLike((LevelAccessor)this.f_19853_, this.m_142538_());
    }

    public ItemStack getMilkBottle() {
        return new ItemStack((ItemLike)ItemRegistry.ATRE_MILK_BOTTLE.get());
    }

    public byte getMilk() {
        return (Byte)this.f_19804_.m_135370_(MILK);
    }

    public void setMilk(byte amount) {
        this.f_19804_.m_135381_(MILK, (Object)amount);
    }

    public void takeMilk() {
        byte amount = this.getMilk();
        if (amount > 0) {
            this.setMilk((byte)(amount - 1));
        }
    }

    public void setFullMilk() {
        this.setMilk((byte)4);
    }

    public boolean canMilk() {
        return !this.m_6162_() && !this.m_27593_() && !this.isAngry() && !this.m_20160_() && this.getMilk() > 0;
    }

    public void m_8035_() {
        if (this.m_6162_()) {
            this.m_146758_(60);
        } else {
            this.setSheared(false);
            this.setFullMilk();
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(ModItemTags.ATRE_FOODS);
    }

    @Override
    public TagKey<Block> getEditablePlants() {
        return ModBlockTags.ATRE_PLANTS;
    }

    @Override
    public Map<Block, Block> getEditableSoils() {
        return SOIL_SAMPLES;
    }

    public Atre getBreedOffspring(ServerLevel world, AgeableMob entity) {
        Atre child = (Atre)((EntityType)EntityRegistry.ATRE.get()).m_20615_((Level)world);
        if (child != null) {
            child.m_21530_();
            child.setNative(CommonUtils.isNetherLike((LevelAccessor)world, entity.m_20097_()));
        }
        return child;
    }

    public SimpleContainer getInventory() {
        return this.stomach;
    }

    public ItemStack addToInventory(ItemStack stack) {
        return this.stomach.m_19173_(stack);
    }

    public boolean canAddToInventory(ItemStack stack) {
        return this.stomach.m_19183_(stack);
    }

    public boolean isStomachEmetic(ItemStack stack) {
        return stack.m_204117_(ModItemTags.ATRE_STOMACH_EMETIC);
    }

    public boolean isStomachItem(ItemStack stack) {
        return stack.m_204117_(ModItemTags.ATRE_STOMACH_ITEMS);
    }

    public void setPuking(int delay) {
        this.pukeTimer = delay;
    }

    public boolean isPuking() {
        return this.pukeTimer > 0;
    }

    public boolean feedEmetic(Player player, InteractionHand hand, ItemStack heldStack) {
        if (!this.f_19853_.f_46443_ && this.isStomachEmetic(heldStack)) {
            player.m_21011_(hand, true);
            this.m_142075_(player, hand, heldStack);
            FXHelper.playSound((LevelAccessor)this.m_20193_(), this.m_142538_(), this.m_7866_(heldStack), SoundSource.NEUTRAL, 1.0f);
            if (!this.getInventory().m_7983_()) {
                this.setPuking(this.f_19796_.nextInt(80, 100));
            }
            return true;
        }
        return false;
    }

    public boolean feedItem(Player player, InteractionHand hand, ItemStack heldStack) {
        if (!this.f_19853_.f_46443_ && this.getInventory().m_19183_(heldStack)) {
            ItemStack feed = heldStack.m_41620_(1);
            player.m_21011_(hand, true);
            this.m_142075_(player, hand, heldStack);
            this.getInventory().m_19173_(feed);
            FXHelper.playSound((LevelAccessor)this.m_20193_(), this.m_142538_(), this.m_7866_(heldStack), SoundSource.NEUTRAL, 1.0f);
            return true;
        }
        return false;
    }

    public void puke() {
        ItemStack pukeStack = ItemHelper.takeItem(this.getInventory());
        if (!pukeStack.m_41619_()) {
            Vec3 vec = Atre.getRandomNearbyPos((PathfinderMob)this);
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, vec);
            FXHelper.fxSmokeParticles(this.f_19853_, vec);
            FXHelper.playSound((LevelAccessor)this.f_19853_, this.m_142538_(), this.getStomachSound(), SoundSource.NEUTRAL, 0.3f, 1.0f);
            BehaviorUtils.m_22613_((LivingEntity)this, (ItemStack)pukeStack, (Vec3)vec.m_82520_(0.0, 1.0, 0.0));
        }
    }

    private static Vec3 getRandomNearbyPos(PathfinderMob entity) {
        Vec3 vec3 = LandRandomPos.m_148488_((PathfinderMob)entity, (int)4, (int)2);
        return vec3 == null ? entity.m_20182_() : vec3;
    }

    public boolean canTeleport() {
        return ItemHelper.hasMatching((Container)this.getInventory(), ModItemTags.ATRE_STOMACH_TELEPORT);
    }

    public boolean targetTeleport(Entity target, int teleportTime) {
        if (this.canTeleport() && !this.m_20160_() && !this.m_20159_() && target != null) {
            return target.m_20280_((Entity)this) > 8.0 && teleportTime >= 30 && TeleportHelper.teleportSelfToTarget((LivingEntity)this, target, true);
        }
        return false;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("Sheared", this.isSheared());
        nbt.m_128379_("Angry", this.isAngry());
        nbt.m_128379_("Native", this.isNative());
        nbt.m_128379_("Native", this.isNative());
        nbt.m_128344_("Milk", this.getMilk());
        nbt.m_128365_("Stomach", (Tag)this.stomach.m_7927_());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setSheared(nbt.m_128471_("Sheared"));
        this.setAngry(nbt.m_128471_("Angry"));
        this.setAngry(nbt.m_128471_("Angry"));
        this.setNative(nbt.m_128471_("Native"));
        this.setMilk(nbt.m_128445_("Milk"));
        this.stomach.m_7797_(nbt.m_128437_("Stomach", 10));
    }

    protected void m_7472_(DamageSource damageSource, int looting, boolean hitByPlayer) {
        super.m_7472_(damageSource, looting, hitByPlayer);
        this.getInventory().m_19195_().forEach(arg_0 -> ((Atre)this).m_19983_(arg_0));
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12345_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return this.isAngry() ? (SoundEvent)SoundRegistry.SOUND_ENTITY_ATRE_ANGRY.get() : (SoundEvent)SoundRegistry.SOUND_ENTITY_ATRE_SAY.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SoundRegistry.SOUND_ENTITY_ATRE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.SOUND_ENTITY_ATRE_ANGRY.get();
    }

    public SoundEvent m_7866_(ItemStack stack) {
        return (SoundEvent)SoundRegistry.SOUND_ENTITY_ATRE_EAT.get();
    }

    protected SoundEvent getStomachSound() {
        return (SoundEvent)SoundRegistry.SOUND_ENTITY_ATRE_PUKE.get();
    }

    public void m_7822_(byte id) {
        if (id == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.m_7822_(id);
        }
    }

    public float getHeadEatPositionScale(float partialTick) {
        if (this.eatAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.eatAnimationTick >= 4 && this.eatAnimationTick <= 36) {
            return 1.0f;
        }
        return this.eatAnimationTick < 4 ? ((float)this.eatAnimationTick - partialTick) / 4.0f : -((float)(this.eatAnimationTick - 40) - partialTick) / 4.0f;
    }

    public float getHeadEatAngleScale(float partialTick) {
        if (this.eatAnimationTick > 4 && this.eatAnimationTick <= 36) {
            float f = ((float)(this.eatAnimationTick - 4) - partialTick) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.m_14031_((float)(f * 28.7f));
        }
        return this.eatAnimationTick > 0 ? 0.62831855f : this.m_146909_() * ((float)Math.PI / 180);
    }

    public static boolean canSpawn(EntityType<Atre> atre, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, Random random) {
        return level.m_8055_(pos.m_7495_()).m_204336_(ModBlockTags.ATRE_SPAWN_BLOCKS);
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public int m_5792_() {
        return 4;
    }

    public boolean m_7296_(int size) {
        return size > 3;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setNative(CommonUtils.isNetherLike((LevelAccessor)level, this.m_20097_()));
        this.setMilk((byte)4);
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        private final Atre atre;
        private int teleportTime;

        public AttackGoal(Atre entity, double speedIn, boolean useLongMemory) {
            super((PathfinderMob)entity, speedIn, useLongMemory);
            this.atre = entity;
        }

        public void m_8056_() {
            this.teleportTime = 0;
            super.m_8056_();
        }

        public void m_8037_() {
            if (this.atre.targetTeleport((Entity)this.atre.m_5448_(), this.teleportTime++)) {
                this.teleportTime = 0;
            }
            super.m_8037_();
        }
    }

    public class RevengeTargetGoal
    extends HurtByTargetGoal {
        public RevengeTargetGoal(PathfinderMob entity, Class<?> ... excludedReinforcementTypes) {
            super(entity, (Class[])excludedReinforcementTypes);
        }

        public boolean m_8036_() {
            if (Atre.this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.f_26135_.m_142581_() instanceof Player) {
                return false;
            }
            return super.m_8036_();
        }
    }

    static class AttackTarget<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        private final Atre atre;
        private int teleportTime;

        public AttackTarget(Atre entity, Class<T> targetClassIn, int targetChanceIn, boolean checkSight, boolean nearbyOnlyIn, Predicate<LivingEntity> targetPredicate) {
            super((Mob)entity, targetClassIn, targetChanceIn, checkSight, nearbyOnlyIn, targetPredicate);
            this.atre = entity;
        }

        public AttackTarget(Atre entity, Class<T> targetClass, int targetChance) {
            this(entity, targetClass, targetChance, true, true, NON_TARGET);
        }

        public void m_8056_() {
            this.teleportTime = 0;
            if (this.f_26050_ != null) {
                if (this.f_26050_.m_6095_().m_204039_(ModEntityTags.ATRE_ATTACK_CAUTIOUSLY)) {
                    int count = this.getReinforcementCount();
                    if (count >= 3) {
                        super.m_8056_();
                    }
                } else {
                    super.m_8056_();
                }
            }
        }

        public void m_8037_() {
            if (this.atre.targetTeleport((Entity)this.f_26050_, this.teleportTime++)) {
                this.teleportTime = 0;
            }
            super.m_8037_();
        }

        protected int getReinforcementCount() {
            double distance = this.m_7623_();
            AABB aABB = AABB.m_82333_((Vec3)this.f_26135_.m_20182_()).m_82377_(distance, 8.0, distance);
            List list = this.atre.f_19853_.m_6443_(this.atre.getClass(), aABB, EntitySelector.f_20408_);
            return list.size();
        }
    }

    static class AtreEatItem
    extends EatItem {
        private final Atre ovis;
        private int teleportTime;

        public AtreEatItem(Atre entity, double speed, TagKey<Item> tag) {
            super(entity, speed, tag);
            this.ovis = entity;
        }

        @Override
        public void m_8056_() {
            this.teleportTime = 0;
            super.m_8056_();
        }

        @Override
        public void m_8037_() {
            if (this.ovis.targetTeleport((Entity)this.target, this.teleportTime++)) {
                this.teleportTime = 0;
            }
            super.m_8037_();
        }
    }
}

