/*
 * Decompiled with CFR 0.152.
 */
package nmd.nethersheep.helpers;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import nmd.nethersheep.Nethersheep;

public class ItemHelper {
    private static final ThreadLocalRandom RANDOM = Nethersheep.RANDOM;

    public static ItemStack insertItemStacked(Container container, ItemStack stack, boolean simulate) {
        ItemStack slot;
        int i;
        if (container == null || stack.m_41619_()) {
            return stack;
        }
        if (!stack.m_41753_()) {
            return ItemHelper.insertItem(container, stack, simulate);
        }
        int sizeInventory = container.m_6643_();
        for (i = 0; !(i >= sizeInventory || ItemHelper.canItemStacksStackRelaxed(slot = container.m_8020_(i), stack) && (stack = ItemHelper.insertItem(container, i, stack, simulate)).m_41619_()); ++i) {
        }
        if (!stack.m_41619_()) {
            for (i = 0; !(i >= sizeInventory || container.m_8020_(i).m_41619_() && (stack = ItemHelper.insertItem(container, i, stack, simulate)).m_41619_()); ++i) {
            }
        }
        return stack;
    }

    public static ItemStack insertItem(Container container, ItemStack stack, boolean simulate) {
        if (container == null || stack.m_41619_()) {
            return stack;
        }
        for (int i = 0; i < container.m_6643_(); ++i) {
            if (!(stack = ItemHelper.insertItem(container, i, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public static ItemStack insertItem(Container container, int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int limit = 64;
        ItemStack existing = container.m_8020_(slot);
        if (!existing.m_41619_()) {
            if (!ItemHelper.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.m_41613_();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            if (existing.m_41619_()) {
                container.m_6836_(slot, reachedLimit ? ItemHelper.copyStackWithSize(stack, limit) : stack);
            } else {
                existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
            }
        }
        return reachedLimit ? ItemHelper.copyStackWithSize(stack, stack.m_41613_() - limit) : ItemStack.f_41583_;
    }

    public static boolean canItemStacksStack(ItemStack a, ItemStack b) {
        if (a.m_41619_() || !a.m_41656_(b) || a.m_41782_() != b.m_41782_()) {
            return false;
        }
        return !a.m_41782_() || a.m_41783_().equals((Object)b.m_41783_());
    }

    public static ItemStack copyStackWithSize(ItemStack itemStack, int size) {
        if (size == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack copy = itemStack.m_41777_();
        copy.m_41764_(size);
        return copy;
    }

    public static boolean canItemStacksStackRelaxed(ItemStack a, ItemStack b) {
        if (a.m_41619_() || b.m_41619_() || a.m_41720_() != b.m_41720_()) {
            return false;
        }
        if (!a.m_41753_()) {
            return false;
        }
        if (a.m_41782_() != b.m_41782_()) {
            return false;
        }
        return a.m_41783_() != null && (!a.m_41782_() || a.m_41783_().equals((Object)b.m_41783_()));
    }

    @Deprecated
    public static boolean takeItemReverse(Container container, Player player) {
        if (container != null) {
            int count;
            for (int i = count = container.m_6643_() - 1; i >= 0; --i) {
                ItemStack check = container.m_8020_(i);
                if (check.m_41619_()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasMatching(Container container, TagKey<Item> tag) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemStack = container.m_8020_(i);
            if (!itemStack.m_204117_(tag)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack takeItem(SimpleContainer container) {
        if (!container.m_7983_()) {
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (stack.m_41619_()) continue;
                ItemStack take = stack.m_41777_();
                container.m_7407_(i, stack.m_41613_());
                return take;
            }
        }
        return ItemStack.f_41583_;
    }

    public static void destroyVanishingCurseItems(Container container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemStack = container.m_8020_(i);
            if (itemStack.m_41619_() || !EnchantmentHelper.m_44924_((ItemStack)itemStack)) continue;
            container.m_7407_(i, itemStack.m_41613_());
        }
    }

    public static ItemStack takeOneItem(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.m_32055_();
        ItemStack split = stack.m_41620_(1);
        if (stack.m_41619_()) {
            itemEntity.m_146870_();
        } else {
            itemEntity.m_32045_(stack);
        }
        return split;
    }
}

