/*
 * Decompiled with CFR 0.152.
 */
package nmd.nethersheep.helpers;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import nmd.nethersheep.Nethersheep;
import nmd.nethersheep.helpers.FXHelper;

public class TeleportHelper {
    public static boolean teleportRandomly(LivingEntity target, int iterations, int range, boolean playSound) {
        for (int i = 0; i < iterations; ++i) {
            double z;
            double y;
            double x = target.m_20185_() + (Nethersheep.RANDOM.nextDouble() - 0.5) * (double)range;
            if (!TeleportHelper.attemptTeleport(target, x, y = target.m_20186_() + (double)(Nethersheep.RANDOM.nextInt(64) - 32), z = target.m_20189_() + (Nethersheep.RANDOM.nextDouble() - 0.5) * (double)range, playSound)) continue;
            return true;
        }
        return false;
    }

    public static boolean teleportSelfToTarget(LivingEntity entity, Entity target, boolean playSound) {
        Vec3 vec3d = new Vec3(entity.m_20185_() - target.m_20185_(), entity.m_142469_().f_82289_ + (double)(entity.m_20206_() / 2.0f) - target.m_20186_() + (double)target.m_20192_(), entity.m_20189_() - target.m_20189_());
        vec3d = vec3d.m_82541_();
        double variation = 16.0;
        double x = entity.m_20185_() + (Nethersheep.RANDOM.nextDouble() - 0.5) * 8.0 - vec3d.f_82479_ * variation;
        double y = entity.m_20186_() + (double)(Nethersheep.RANDOM.nextInt(16) - 8) - vec3d.f_82480_ * variation;
        double z = entity.m_20189_() + (Nethersheep.RANDOM.nextDouble() - 0.5) * 8.0 - vec3d.f_82481_ * variation;
        return TeleportHelper.attemptTeleport(entity, x, y, z, playSound);
    }

    public static boolean attemptTeleport(LivingEntity target, double x, double y, double z, boolean playSound) {
        Level world = target.m_20193_();
        BlockPos origin = target.m_20097_();
        BlockPos destination = new BlockPos(x, y, z);
        if (target.m_20984_((double)destination.m_123341_(), (double)destination.m_123342_(), (double)destination.m_123343_(), true)) {
            if (playSound) {
                FXHelper.playSound((LevelAccessor)world, origin, SoundEvents.f_11852_, 1.0f);
                target.m_5496_(SoundEvents.f_11852_, 1.0f, 2.6f + (Nethersheep.RANDOM.nextFloat() - Nethersheep.RANDOM.nextFloat()) * 0.8f);
            }
            FXHelper.drawParticleTrail((ParticleOptions)ParticleTypes.f_123760_, world, origin, target.m_142538_());
            target.f_19789_ = 0.0f;
            return true;
        }
        return false;
    }
}

