/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.riddlechests.block;

import com.davenonymous.libnonymous.base.BaseNamedContainerProvider;
import com.davenonymous.libnonymous.base.WaterloggedBaseBlock;
import com.davenonymous.riddlechests.block.RiddleChestTileEntity;
import com.davenonymous.riddlechests.gui.OpenRiddleChestContainer;
import com.davenonymous.riddlechests.network.Networking;
import com.davenonymous.riddlechests.recipe.riddles.RiddleInfo;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public class RiddleChestBlock
extends WaterloggedBaseBlock {
    private final VoxelShape shapeX = VoxelShapes.func_197873_a((double)0.15f, (double)0.005f, (double)0.065f, (double)0.85f, (double)0.7f, (double)0.935f);
    private final VoxelShape shapeZ = VoxelShapes.func_197873_a((double)0.065f, (double)0.005f, (double)0.15f, (double)0.935f, (double)0.7f, (double)0.85f);

    public RiddleChestBlock() {
        super(Block.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151650_B).func_200948_a(15.0f, 1200.0f).func_200947_a(SoundType.field_185848_a).harvestTool(ToolType.AXE).harvestLevel(2));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            return this.shapeZ;
        }
        return this.shapeX;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new RiddleChestTileEntity();
    }

    public RiddleChestTileEntity getOwnTile(IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof RiddleChestTileEntity)) {
            return null;
        }
        return (RiddleChestTileEntity)te;
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_70093_af()) {
            return false;
        }
        if (worldIn.field_72995_K || !(player instanceof ServerPlayerEntity)) {
            return true;
        }
        if (handIn != Hand.MAIN_HAND) {
            return false;
        }
        RiddleChestTileEntity chestTile = this.getOwnTile((IBlockReader)worldIn, pos);
        if (chestTile == null) {
            return false;
        }
        if (chestTile.solved) {
            worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new BaseNamedContainerProvider((ITextComponent)new StringTextComponent("Riddle Chest"), (id, inv, playerEntity) -> new OpenRiddleChestContainer((int)id, (PlayerInventory)inv, worldIn, pos)), (BlockPos)pos);
            return true;
        }
        RiddleInfo riddle = chestTile.getRiddle();
        if (riddle == null) {
            return false;
        }
        Networking.sendOpenRiddleChestPacketToClient((ServerPlayerEntity)player, pos);
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        RiddleChestTileEntity chestTile;
        super.func_180633_a(world, pos, state, placer, stack);
        if (placer == null) {
            return;
        }
        world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)RiddleChestBlock.getFacingFromEntity((BlockPos)pos, (LivingEntity)placer, (boolean)true)), 2);
        if (stack.func_77942_o() && (chestTile = this.getOwnTile((IBlockReader)world, pos)) != null) {
            ResourceLocation existingRiddle;
            chestTile.linkedRiddle = existingRiddle = ResourceLocation.func_208304_a((String)stack.func_77978_p().func_74779_i("riddle"));
            chestTile.solved = stack.func_77978_p().func_74767_n("solved");
            chestTile.func_70296_d();
            chestTile.notifyClients();
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        RiddleChestTileEntity chestTile = this.getOwnTile((IBlockReader)worldIn, pos);
        if (chestTile == null) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            return;
        }
        if (chestTile.solved) {
            InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, chestTile.getContentStacks());
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208157_J});
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }
}

