/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.riddlechests.gui;

import com.davenonymous.libnonymous.gui.framework.GUI;
import com.davenonymous.libnonymous.gui.framework.GUIHelper;
import com.davenonymous.libnonymous.gui.framework.event.KeyReleasedEvent;
import com.davenonymous.libnonymous.gui.framework.event.ValueChangedEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.libnonymous.gui.framework.widgets.Widget;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetPanel;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetTextBox;
import com.davenonymous.riddlechests.gui.RiddleSolvedEvent;
import com.davenonymous.riddlechests.gui.WidgetWordSolution;
import com.davenonymous.riddlechests.recipe.alphabets.AlphabetInfo;
import com.davenonymous.riddlechests.recipe.riddles.RiddleInfo;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;

public class RiddleChestGUI
extends GUI {
    private static ResourceLocation backgroundTexture = new ResourceLocation("riddlechests", "textures/gui/krondor.png");
    private final RiddleInfo riddle;
    private final AlphabetInfo alphabet;

    public RiddleChestGUI(RiddleInfo riddle, AlphabetInfo alphabet, int width, int height) {
        super(0, 0, width, height);
        this.riddle = riddle;
        this.alphabet = alphabet;
        this.add((Widget)this.createPanel());
        this.addListener(KeyReleasedEvent.class, (event, widget) -> {
            if (event.keyCode == 69) {
                Minecraft.func_71410_x().field_71462_r.onClose();
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    private WidgetPanel createPanel() {
        WidgetPanel panel = new WidgetPanel();
        panel.setX(0);
        panel.setY(0);
        panel.setWidth(this.width);
        panel.setHeight(this.height);
        WidgetWordSolution wordInput = new WidgetWordSolution(this.riddle, this.alphabet);
        wordInput.setX((panel.width - wordInput.width) / 2);
        wordInput.addListener(ValueChangedEvent.class, (event, widget) -> {
            String newValue = (String)event.newValue;
            if (this.riddle.solution.equalsIgnoreCase(newValue)) {
                this.fireEvent(new RiddleSolvedEvent());
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        panel.add((Widget)wordInput);
        WidgetPanel linesPanel = new WidgetPanel();
        linesPanel.setSize(512, 512);
        int yOffset = 0;
        for (String line : this.riddle.lines) {
            WidgetTextBox textBox = new WidgetTextBox(line, 0xAAAAAA);
            int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(line);
            int xOffset = (linesPanel.width - width) / 2;
            textBox.setWidth(width);
            textBox.setY(yOffset);
            textBox.setX(xOffset);
            linesPanel.add((Widget)textBox);
            yOffset += textBox.height + 1;
        }
        linesPanel.adjustSizeToContent();
        linesPanel.setY((panel.height - linesPanel.height) / 2);
        linesPanel.setX((panel.width - linesPanel.width) / 2);
        wordInput.setY(linesPanel.y);
        linesPanel.setY(linesPanel.y + 28);
        this.add((Widget)linesPanel);
        return panel;
    }

    protected void drawWindow(Screen screen) {
        super.drawWindow(screen);
        GlStateManager.disableLighting();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        screen.getMinecraft().func_110434_K().func_110577_a(backgroundTexture);
        GUIHelper.drawStretchedTexture((int)0, (int)0, (int)this.width, (int)this.height, (int)0, (int)0, (int)256, (int)256);
    }
}

