/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.riddlechests.recipe.alphabets;

import com.davenonymous.riddlechests.recipe.alphabets.AlphabetInfo;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AlphabetSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<AlphabetInfo> {
    private static final String[] requiredProperties = new String[]{"validChars"};

    public AlphabetSerializer() {
        this.setRegistryName("riddlechests", "alphabet");
    }

    public AlphabetInfo read(ResourceLocation recipeId, JsonObject json) {
        for (String required : requiredProperties) {
            if (json.has(required)) continue;
            throw new JsonParseException(String.format("Invalid alphabet! Missing property: %s", required));
        }
        AlphabetInfo result = new AlphabetInfo(recipeId);
        StringBuilder validChars = new StringBuilder();
        for (JsonElement el : json.getAsJsonArray("validChars")) {
            if (!el.isJsonPrimitive()) continue;
            validChars.append(el.getAsString());
        }
        result.validCharacters = validChars.toString();
        return result;
    }

    @Nullable
    public AlphabetInfo read(ResourceLocation recipeId, PacketBuffer buffer) {
        AlphabetInfo result = new AlphabetInfo(recipeId);
        result.validCharacters = buffer.func_218666_n();
        return result;
    }

    public void write(PacketBuffer buffer, AlphabetInfo recipe) {
        buffer.func_180714_a(recipe.validCharacters);
    }
}

