/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.riddlechests.setup;

import com.davenonymous.riddlechests.event.GenerateChestEvent;
import com.davenonymous.riddlechests.event.SetLootTableEvent;
import com.davenonymous.riddlechests.setup.Config;
import com.davenonymous.riddlechests.setup.ModObjects;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class WorldGenEvents {
    private static Field FIELD_LOOTTABLE = ObfuscationReflectionHelper.findField(LockableLootTileEntity.class, (String)"field_184284_m");
    private static Map<Integer, Set<BlockPos>> alreadyProcessedChests;

    private static ResourceLocation getLootTableFromLockableLootTileEntity(LockableLootTileEntity tile) {
        try {
            return (ResourceLocation)FIELD_LOOTTABLE.get(tile);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void addProcessedChestPosition(WorldGenRegion world, BlockPos pos) {
        int dim;
        if (alreadyProcessedChests == null) {
            alreadyProcessedChests = new HashMap<Integer, Set<BlockPos>>();
        }
        if (!alreadyProcessedChests.containsKey(dim = world.func_201675_m().func_186058_p().func_186068_a())) {
            alreadyProcessedChests.put(dim, new HashSet());
        }
        alreadyProcessedChests.get(dim).add(pos);
    }

    private static boolean alreadyProcessed(WorldGenRegion world, BlockPos pos) {
        if (alreadyProcessedChests == null) {
            return false;
        }
        int dim = world.func_201675_m().func_186058_p().func_186068_a();
        if (!alreadyProcessedChests.containsKey(dim)) {
            return false;
        }
        return alreadyProcessedChests.get(dim).contains(pos);
    }

    private static void tryReplaceChest(WorldGenRegion world, BlockPos pos) {
        if (WorldGenEvents.alreadyProcessed(world, pos)) {
            return;
        }
        WorldGenEvents.addProcessedChestPosition(world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return;
        }
        if (!(tile instanceof LockableLootTileEntity)) {
            return;
        }
        ResourceLocation originalLocation = WorldGenEvents.getLootTableFromLockableLootTileEntity((LockableLootTileEntity)tile);
        Config.updateBlacklistedChests();
        if (originalLocation != null && Config.blacklistedChests.contains(originalLocation)) {
            return;
        }
        double rolled = world.func_201674_k().nextDouble();
        if (rolled > (Double)Config.CHANCE_TO_REPLACE_CHEST.get()) {
            return;
        }
        Direction newDirection = Direction.func_176731_b((int)world.func_201674_k().nextInt(4));
        BlockState originalState = world.func_180495_p(pos);
        if (originalState.func_196959_b((IProperty)ChestBlock.field_176459_a)) {
            newDirection = (Direction)originalState.func_177229_b((IProperty)ChestBlock.field_176459_a);
        }
        BlockState newState = (BlockState)ModObjects.RIDDLECHEST.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)newDirection);
        world.func_217377_a(pos, false);
        world.func_180501_a(pos, newState, 3);
    }

    @SubscribeEvent
    public static void onSetLootTable(SetLootTableEvent event) {
        if (event.getWorld() instanceof WorldGenRegion) {
            WorldGenEvents.tryReplaceChest((WorldGenRegion)event.getWorld(), event.getPos());
        }
    }

    @SubscribeEvent
    public static void onGenerateChest(GenerateChestEvent event) {
        if (event.getWorld() instanceof WorldGenRegion) {
            WorldGenEvents.tryReplaceChest((WorldGenRegion)event.getWorld(), event.getPos());
        }
    }

    static {
        if (FIELD_LOOTTABLE != null) {
            FIELD_LOOTTABLE.setAccessible(true);
        }
    }
}

