/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.riddlechests.block;

import com.davenonymous.libnonymous.base.BaseTileEntity;
import com.davenonymous.libnonymous.serialization.Store;
import com.davenonymous.riddlechests.recipe.riddles.RiddleInfo;
import com.davenonymous.riddlechests.setup.ModObjects;
import com.davenonymous.riddlechests.util.Logz;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class RiddleChestTileEntity
extends BaseTileEntity {
    @Store(storeWithItem=true, sendInUpdatePackage=true)
    public boolean solved;
    @Store(storeWithItem=true, sendInUpdatePackage=true)
    public ResourceLocation linkedRiddle;
    private LazyOptional<ItemStackHandler> handler = LazyOptional.of(this::createHandler);
    public RiddleInfo cachedRiddle;

    public RiddleChestTileEntity() {
        super(ModObjects.RIDDLECHEST_TILE);
    }

    public RiddleInfo getRiddle() {
        if (this.cachedRiddle == null && this.linkedRiddle != null) {
            this.cachedRiddle = (RiddleInfo)ModObjects.riddleRecipeHelper.getRecipe(this.field_145850_b.func_199532_z(), this.linkedRiddle);
            if (this.cachedRiddle == null) {
                this.setNewRiddle();
            }
        }
        return this.cachedRiddle;
    }

    private void setNewRiddle() {
        this.cachedRiddle = (RiddleInfo)ModObjects.riddleRecipeHelper.getRandomRecipe(this.field_145850_b.func_199532_z(), this.field_145850_b.field_73012_v);
        if (this.cachedRiddle == null) {
            this.linkedRiddle = null;
            return;
        }
        this.linkedRiddle = this.cachedRiddle.func_199560_c();
        this.func_70296_d();
        this.notifyClients();
    }

    protected void initialize() {
        super.initialize();
        if (this.linkedRiddle == null) {
            this.setNewRiddle();
        }
    }

    public void generateLoot(ServerPlayerEntity player) {
        this.handler.ifPresent(handler -> {
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < handler.getSlots(); ++i) {
                list.add(i);
            }
            Collections.shuffle(list, this.field_145850_b.field_73012_v);
            Set<ResourceLocation> lootTableIds = ModObjects.lootTableMappingRecipeHelper.getLootTablesForCategory(this.cachedRiddle.category, this.field_145850_b.func_199532_z());
            for (ResourceLocation lootTableId : lootTableIds) {
                LootTable lootTable = this.field_145850_b.func_73046_m().func_200249_aQ().func_186521_a(lootTableId);
                if (lootTable == null) {
                    Logz.warn("While generating riddle chest loot: Loottable '{}' does not exist. Check the loottable mapping of '{}'.", lootTableId, this.cachedRiddle.category);
                    continue;
                }
                LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216015_a(LootParameters.field_216286_f, (Object)new BlockPos((Vec3i)this.field_174879_c)).func_216016_a(this.field_145850_b.field_73012_v.nextLong());
                if (player != null) {
                    builder.func_186469_a(player.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)player);
                }
                LootContext lootContext = builder.func_216022_a(LootParameterSets.field_216261_b);
                lootTable.func_216120_b(lootContext, itemStack -> {
                    if (list.size() <= 0) {
                        return;
                    }
                    Integer slotToFill = (Integer)list.remove(0);
                    handler.insertItem(slotToFill.intValue(), itemStack, false);
                });
            }
        });
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145839_a(CompoundNBT tag) {
        CompoundNBT invTag = tag.func_74775_l("inv");
        this.handler.ifPresent(h -> h.deserializeNBT(invTag));
        super.func_145839_a(tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.handler.ifPresent(h -> {
            CompoundNBT compound = h.serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(54){

            protected void onContentsChanged(int slot) {
                RiddleChestTileEntity.this.func_70296_d();
            }
        };
    }

    public NonNullList<ItemStack> getContentStacks() {
        NonNullList result = NonNullList.func_191196_a();
        this.handler.ifPresent(h -> {
            for (int slot = 0; slot < h.getSlots(); ++slot) {
                ItemStack content = h.getStackInSlot(slot);
                if (content.func_190926_b()) continue;
                result.add((Object)content.func_77946_l());
            }
        });
        return result;
    }
}

