/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.riddlechests.gui;

import com.davenonymous.libnonymous.gui.framework.GUI;
import com.davenonymous.libnonymous.gui.framework.WidgetScreen;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.libnonymous.gui.framework.widgets.Widget;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetTextBox;
import com.davenonymous.riddlechests.RiddleChests;
import com.davenonymous.riddlechests.block.RiddleChestTileEntity;
import com.davenonymous.riddlechests.gui.RiddleChestGUI;
import com.davenonymous.riddlechests.gui.RiddleSolvedEvent;
import com.davenonymous.riddlechests.network.Networking;
import com.davenonymous.riddlechests.recipe.alphabets.AlphabetInfo;
import com.davenonymous.riddlechests.recipe.riddles.RiddleInfo;
import com.davenonymous.riddlechests.setup.ModObjects;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;

public class RiddleChestScreen
extends WidgetScreen {
    private BlockPos pos;

    public RiddleChestScreen(BlockPos pos) {
        super((ITextComponent)new StringTextComponent("Riddle Chest"));
        this.pos = pos;
    }

    private GUI createErrorScreen(String message) {
        GUI gui = new GUI(0, 0, 250, 30);
        WidgetTextBox errorMsg = new WidgetTextBox(message, -65536);
        errorMsg.setDimensions(5, 5, 240, 9);
        gui.add((Widget)errorMsg);
        return gui;
    }

    protected GUI createGUI() {
        RiddleChestTileEntity chestTile = ModObjects.RIDDLECHEST.getOwnTile((IBlockReader)RiddleChests.proxy.getClientWorld(), this.pos);
        if (chestTile == null) {
            return this.createErrorScreen("Oops. Something went wrong!");
        }
        RiddleInfo riddle = chestTile.getRiddle();
        if (riddle == null) {
            return this.createErrorScreen("Oops. This chest has no riddle?! Tell Dave about this!");
        }
        AlphabetInfo alphabetInfo = (AlphabetInfo)ModObjects.alphabetRecipeHelper.getRecipe(RiddleChests.proxy.getClientWorld().func_199532_z(), riddle.alphabet);
        if (alphabetInfo == null) {
            return this.createErrorScreen("Oops. Unknown alphabet for this riddle!");
        }
        int height = (int)((double)Minecraft.func_71410_x().func_228018_at_().func_198083_n() / Minecraft.func_71410_x().func_228018_at_().func_198100_s());
        int width = (int)((double)Minecraft.func_71410_x().func_228018_at_().func_198105_m() / Minecraft.func_71410_x().func_228018_at_().func_198100_s());
        RiddleChestGUI gui = new RiddleChestGUI(riddle, alphabetInfo, width, height);
        gui.addListener(RiddleSolvedEvent.class, (event, widget) -> {
            Networking.sendSolvedRiddleToServer(this.pos);
            return WidgetEventResult.HANDLED;
        });
        return gui;
    }
}

