/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.riddlechests.gui;

import com.davenonymous.libnonymous.gui.framework.event.IEvent;
import com.davenonymous.libnonymous.gui.framework.event.ValueChangedEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.libnonymous.gui.framework.widgets.Widget;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetPanel;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetSelectButton;
import com.davenonymous.riddlechests.recipe.alphabets.AlphabetInfo;
import com.davenonymous.riddlechests.recipe.riddles.RiddleInfo;
import com.davenonymous.riddlechests.setup.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.util.SoundEvents;

public class WidgetWordSolution
extends WidgetPanel {
    List<WidgetSelectButton<String>> charButtons = new ArrayList<WidgetSelectButton<String>>();
    String value;

    public WidgetWordSolution(RiddleInfo riddle, AlphabetInfo alphabet) {
        this.value = riddle.original;
        String choices = alphabet.validCharacters;
        HashSet<String> choiceSet = new HashSet<String>(Arrays.asList(choices.split("")));
        Random seededRand = new Random(riddle.randomSeed);
        int buttonDim = 20;
        int xOffset = 0;
        for (int pos = 0; pos < riddle.original.length(); ++pos) {
            String solutionChar = riddle.solution.substring(pos, pos + 1);
            String originalChar = riddle.original.substring(pos, pos + 1);
            HashSet<String> validChoices = new HashSet<String>();
            validChoices.add(originalChar);
            validChoices.add(solutionChar);
            List remainingChoices = choiceSet.stream().filter(c -> !validChoices.contains(c)).collect(Collectors.toList());
            while (validChoices.size() <= (Integer)Config.ADDITIONAL_CHARS.get() && remainingChoices.size() > 0) {
                int choice = seededRand.nextInt(remainingChoices.size());
                validChoices.add((String)remainingChoices.get(choice));
                remainingChoices.remove(choice);
            }
            WidgetSelectButton selectButton = new WidgetSelectButton();
            selectButton.setClickSound(SoundEvents.field_219719_ml);
            selectButton.setWidth(20);
            selectButton.setHeight(20);
            selectButton.addChoice(validChoices);
            selectButton.setX(xOffset);
            selectButton.setValue((Object)riddle.original.substring(pos, pos + 1));
            selectButton.addListener(ValueChangedEvent.class, (event, widget) -> {
                String newValue;
                String oldValue = this.value;
                this.value = newValue = this.calculateValue();
                this.fireEvent((IEvent)new ValueChangedEvent((Object)oldValue, (Object)newValue));
                return WidgetEventResult.CONTINUE_PROCESSING;
            });
            if (solutionChar.equals(" ")) {
                selectButton.setEnabled(false);
                selectButton.setVisible(false);
            }
            this.charButtons.add((WidgetSelectButton<String>)selectButton);
            this.add((Widget)selectButton);
            xOffset += buttonDim + 1;
        }
        this.setWidth(xOffset - 1);
        this.setHeight(buttonDim);
    }

    public String getValue() {
        return this.value;
    }

    public String calculateValue() {
        StringBuilder builder = new StringBuilder();
        this.charButtons.forEach(button -> builder.append((String)button.getValue()));
        return builder.toString();
    }
}

