/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.riddlechests.recipe.loottable;

import com.davenonymous.riddlechests.recipe.loottable.LootTableMappingInfo;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class LootTableMappingSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<LootTableMappingInfo> {
    private static final String[] requiredProperties = new String[]{"lootTables", "category"};

    public LootTableMappingSerializer() {
        this.setRegistryName(new ResourceLocation("riddlechests", "loottable_mapping"));
    }

    public LootTableMappingInfo read(ResourceLocation recipeId, JsonObject json) {
        for (String required : requiredProperties) {
            if (json.has(required)) continue;
            throw new JsonParseException(String.format("Invalid riddle! Missing property: %s", required));
        }
        LootTableMappingInfo info = new LootTableMappingInfo(recipeId);
        info.categoryId = ResourceLocation.func_208304_a((String)json.get("category").getAsString());
        HashSet<ResourceLocation> mappedLootTables = new HashSet<ResourceLocation>();
        for (JsonElement el : json.getAsJsonArray("lootTables")) {
            mappedLootTables.add(ResourceLocation.func_208304_a((String)el.getAsString()));
        }
        info.mappedLootTables = mappedLootTables;
        return info;
    }

    @Nullable
    public LootTableMappingInfo read(ResourceLocation recipeId, PacketBuffer buffer) {
        LootTableMappingInfo info = new LootTableMappingInfo(recipeId);
        info.categoryId = buffer.func_192575_l();
        int tableCount = buffer.readInt();
        HashSet<ResourceLocation> mappedLootTables = new HashSet<ResourceLocation>();
        for (int i = 0; i < tableCount; ++i) {
            mappedLootTables.add(buffer.func_192575_l());
        }
        return info;
    }

    public void write(PacketBuffer buffer, LootTableMappingInfo recipe) {
        buffer.func_192572_a(recipe.categoryId);
        buffer.writeInt(recipe.mappedLootTables.size());
        recipe.mappedLootTables.stream().forEach(arg_0 -> ((PacketBuffer)buffer).func_192572_a(arg_0));
    }
}

