/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.riddlechests.recipe.riddles;

import com.davenonymous.riddlechests.recipe.riddles.RiddleInfo;
import com.davenonymous.riddlechests.setup.Config;
import com.davenonymous.riddlechests.util.Logz;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RiddleSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RiddleInfo> {
    private static final ResourceLocation defaultAlphabet = new ResourceLocation("riddlechests", "alphabets/en_us");
    private static final String[] requiredProperties = new String[]{"lang", "category", "original", "solution", "riddle"};

    public RiddleSerializer() {
        this.setRegistryName(new ResourceLocation("riddlechests", "word"));
    }

    public RiddleInfo read(ResourceLocation recipeId, JsonObject json) {
        for (String required : requiredProperties) {
            if (json.has(required)) continue;
            Logz.info(String.format("Invalid riddle! Missing property: %s", required), new Object[0]);
            return null;
        }
        RiddleInfo info = new RiddleInfo(recipeId);
        info.lang = "en_us";
        if (json.has("lang")) {
            info.lang = json.get("lang").getAsString();
        }
        info.alphabet = defaultAlphabet;
        if (json.has("alphabet")) {
            info.alphabet = new ResourceLocation(json.get("alphabet").getAsString());
        }
        String category = json.get("category").getAsString();
        if (((List)Config.DISABLE_RIDDLE_CATEGORIES.get()).contains(category)) {
            Logz.debug("Skipping riddle '{}'! Category '{}' is disabled", new Object[0]);
            return null;
        }
        info.category = new ResourceLocation(json.get("category").getAsString());
        info.original = json.get("original").getAsString();
        info.solution = json.get("solution").getAsString();
        if (info.original.length() != info.solution.length()) {
            Logz.info(String.format("Invalid riddle! Length of original and solution does not match!", new Object[0]), new Object[0]);
            return null;
        }
        ArrayList<String> riddleLines = new ArrayList<String>();
        json.getAsJsonArray("riddle").forEach(l -> riddleLines.add(l.getAsString()));
        info.lines = riddleLines;
        info.randomSeed = RiddleSerializer.stringToSeed(info.original + info.solution);
        return info;
    }

    @Nullable
    public RiddleInfo read(ResourceLocation recipeId, PacketBuffer buffer) {
        RiddleInfo info = new RiddleInfo(recipeId);
        info.alphabet = buffer.func_192575_l();
        info.category = buffer.func_192575_l();
        info.lang = buffer.func_218666_n();
        info.original = buffer.func_218666_n();
        info.solution = buffer.func_218666_n();
        info.randomSeed = RiddleSerializer.stringToSeed(info.original + info.solution);
        info.lines = new ArrayList<String>();
        int lineCount = buffer.readInt();
        for (int i = 0; i < lineCount; ++i) {
            info.lines.add(buffer.func_218666_n());
        }
        return info;
    }

    public void write(PacketBuffer buffer, RiddleInfo recipe) {
        buffer.func_192572_a(recipe.alphabet);
        buffer.func_192572_a(recipe.category);
        buffer.func_180714_a(recipe.lang);
        buffer.func_180714_a(recipe.original);
        buffer.func_180714_a(recipe.solution);
        buffer.writeInt(recipe.lines.size());
        recipe.lines.forEach(s -> buffer.func_180714_a(s));
    }

    private static long stringToSeed(String s) {
        if (s == null) {
            return 0L;
        }
        long hash = 0L;
        for (char c : s.toCharArray()) {
            hash = 31L * hash + (long)c;
        }
        return hash;
    }
}

