/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.riddlechests.setup;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber
public class Config {
    public static final String CATEGORY_GENERAL = "general";
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec CLIENT_CONFIG;
    public static ForgeConfigSpec.IntValue ADDITIONAL_CHARS;
    public static ForgeConfigSpec.DoubleValue CHANCE_TO_REPLACE_CHEST;
    public static ForgeConfigSpec.ConfigValue<List<String>> NEVER_REPLACE_LOOTTABLES;
    public static ForgeConfigSpec.ConfigValue<List<String>> DISABLE_RIDDLE_CATEGORIES;
    public static Set<ResourceLocation> blacklistedChests;

    private static void setupGeneralConfig(ForgeConfigSpec.Builder b) {
        ADDITIONAL_CHARS = b.comment("How many extra characters for each riddle?").defineInRange("extraChars", 9, 1, 25);
        CHANCE_TO_REPLACE_CHEST = b.comment("How likely is a vanilla loot chest being replaced by a riddle chest?").defineInRange("chestReplaceChance", 0.125, 0.0, 1.0);
        NEVER_REPLACE_LOOTTABLES = b.comment("Never replace vanilla chests that have one of these loot tables assigned").define("loottableBlacklist", Arrays.asList("minecraft:chests/shipwreck_map", "minecraft:chests/spawn_bonus_chest"), o -> true);
        DISABLE_RIDDLE_CATEGORIES = b.comment("Categories listed here will not be loaded. Add 'riddlechests:betrayal_at_krondor' to disable the built in riddles. Make sure to have at least one loaded category!").define("disableCategories", Arrays.asList(""), o -> true);
    }

    private static void setupClientConfig(ForgeConfigSpec.Builder b) {
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
    }

    @SubscribeEvent
    public static void onReload(ModConfig.ModConfigEvent configEvent) {
    }

    public static void updateBlacklistedChests() {
        blacklistedChests = ((List)NEVER_REPLACE_LOOTTABLES.get()).stream().map(ResourceLocation::func_208304_a).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    static {
        COMMON_BUILDER.comment("General Settings").push(CATEGORY_GENERAL);
        Config.setupGeneralConfig(COMMON_BUILDER);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
        CLIENT_BUILDER.comment("General Settings").push(CATEGORY_GENERAL);
        Config.setupClientConfig(CLIENT_BUILDER);
        CLIENT_BUILDER.pop();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }
}

