/*
 * Decompiled with CFR 0.152.
 */
package schauweg.timetolive.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;
import schauweg.timetolive.Main;
import schauweg.timetolive.config.TTLConfig;

public class TTLConfigManger {
    private static File file;
    private static TTLConfig config;

    private static void prepareConfigFile() {
        if (file != null) {
            return;
        }
        file = FabricLoader.getInstance().getConfigDir().resolve("timetolive.json").toFile();
    }

    public static TTLConfig initializeConfig() {
        if (config != null) {
            return config;
        }
        config = new TTLConfig();
        TTLConfigManger.load();
        return config;
    }

    private static void load() {
        TTLConfigManger.prepareConfigFile();
        try {
            BufferedReader br;
            TTLConfig parsed;
            if (!file.exists()) {
                TTLConfigManger.save();
            }
            if (file.exists() && (parsed = (TTLConfig)Main.GSON.fromJson((Reader)(br = new BufferedReader(new FileReader(file))), TTLConfig.class)) != null) {
                config = parsed;
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Couldn't load Login Toast configuration file; reverting to defaults");
            e.printStackTrace();
        }
    }

    public static void save() {
        TTLConfigManger.prepareConfigFile();
        String jsonString = Main.GSON.toJson((Object)config);
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(jsonString);
        }
        catch (IOException e) {
            System.err.println("Couldn't save Login Toast configuration file");
            e.printStackTrace();
        }
    }

    public static TTLConfig getConfig() {
        if (config == null) {
            config = new TTLConfig();
        }
        return config;
    }
}

