/*
 * Decompiled with CFR 0.152.
 */
package schauweg.timetolive;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.lwjgl.opengl.GL11;

public class TNTCountdownRenderer {
    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity cameraEntity = mc.func_175606_aa();
        BlockPos renderingVector = cameraEntity.func_180425_c();
        Frustum frustum = new Frustum();
        float partialTicks = event.getPartialTicks();
        double viewX = cameraEntity.field_70142_S + (cameraEntity.field_70165_t - cameraEntity.field_70142_S) * (double)partialTicks;
        double viewY = cameraEntity.field_70137_T + (cameraEntity.field_70163_u - cameraEntity.field_70137_T) * (double)partialTicks;
        double viewZ = cameraEntity.field_70136_U + (cameraEntity.field_70161_v - cameraEntity.field_70136_U) * (double)partialTicks;
        frustum.func_78547_a(viewX, viewY, viewZ);
        ClientWorld client = mc.field_71441_e;
        Iterable entitiesById = client.func_217416_b();
        for (Entity entity : entitiesById) {
            if (entity == null || !(entity instanceof TNTEntity) || !entity.func_145770_h((double)renderingVector.func_177958_n(), (double)renderingVector.func_177956_o(), (double)renderingVector.func_177952_p()) || !entity.field_70158_ak && !frustum.func_78546_a(entity.func_174813_aQ())) continue;
            this.renderFuseCountdown((TNTEntity)entity, partialTicks, 0.5f);
        }
    }

    private void renderFuseCountdown(TNTEntity passedEntity, float partialTicks, float nameOffset) {
        Minecraft mc = Minecraft.func_71410_x();
        float pastTranslate = 0.0f;
        int fuse = passedEntity.func_184536_l();
        String fuseText = TNTCountdownRenderer.ticksToTime(fuse);
        double x = passedEntity.field_70142_S + (passedEntity.field_70165_t - passedEntity.field_70142_S) * (double)partialTicks;
        double y = passedEntity.field_70137_T + (passedEntity.field_70163_u - passedEntity.field_70137_T) * (double)partialTicks;
        double z = passedEntity.field_70136_U + (passedEntity.field_70161_v - passedEntity.field_70136_U) * (double)partialTicks;
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        double renderPosX = (Double)ObfuscationReflectionHelper.getPrivateValue(EntityRendererManager.class, (Object)renderManager, (String)"field_78725_b");
        double renderPosY = (Double)ObfuscationReflectionHelper.getPrivateValue(EntityRendererManager.class, (Object)renderManager, (String)"field_78726_c");
        double renderPosZ = (Double)ObfuscationReflectionHelper.getPrivateValue(EntityRendererManager.class, (Object)renderManager, (String)"field_78723_d");
        GlStateManager.translatef((float)0.0f, (float)pastTranslate, (float)0.0f);
        float scale = 0.026666673f;
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)(x - renderPosX)), (float)((float)(y - renderPosY + (double)passedEntity.func_213302_cg()) + nameOffset), (float)((float)(z - renderPosZ)));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.scalef((float)(-scale), (float)(-scale), (float)scale);
        boolean lighting = GL11.glGetBoolean((int)2896);
        GlStateManager.disableLighting();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.disableDepthTest();
        GlStateManager.disableTexture();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        int j = mc.field_71466_p.func_78256_a(fuseText) / 2;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)(-j - 1), -1.0, 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
        buffer.func_181662_b((double)(-j - 1), 8.0, 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
        buffer.func_181662_b((double)(j + 1), 8.0, 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
        buffer.func_181662_b((double)(j + 1), -1.0, 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.enableTexture();
        mc.field_71466_p.func_211126_b(fuseText, (float)(-j), 0.0f, 0x20FFFFFF);
        GlStateManager.enableDepthTest();
        GlStateManager.depthMask((boolean)true);
        if (lighting) {
            GlStateManager.enableLighting();
        }
        mc.field_71466_p.func_211126_b(fuseText, (float)(-j), 0.0f, -1);
        GlStateManager.disableBlend();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }

    private static String ticksToTime(int ticks) {
        if (ticks > 72000) {
            int h = ticks / 20 / 3600;
            return h + " h";
        }
        if (ticks > 1200) {
            int m = ticks / 20 / 60;
            return m + " m";
        }
        int s = ticks / 20;
        int ms = ticks % 20 / 2;
        return s + "." + ms + " s";
    }
}

