/*
 * Decompiled with CFR 0.152.
 */
package net.quantumfusion.dashloader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_376;
import net.minecraft.class_386;
import net.minecraft.class_390;
import net.minecraft.class_391;
import net.minecraft.class_815;
import net.quantumfusion.dashloader.DashLoader;
import net.quantumfusion.dashloader.api.models.DashModelFactory;
import net.quantumfusion.dashloader.api.properties.DashPropertyFactory;
import net.quantumfusion.dashloader.atlas.DashImage;
import net.quantumfusion.dashloader.atlas.DashSprite;
import net.quantumfusion.dashloader.blockstates.DashBlockState;
import net.quantumfusion.dashloader.blockstates.properties.DashProperty;
import net.quantumfusion.dashloader.blockstates.properties.value.DashPropertyValue;
import net.quantumfusion.dashloader.common.DashID;
import net.quantumfusion.dashloader.common.DashIdentifier;
import net.quantumfusion.dashloader.font.fonts.DashBitmapFont;
import net.quantumfusion.dashloader.font.fonts.DashBlankFont;
import net.quantumfusion.dashloader.font.fonts.DashFont;
import net.quantumfusion.dashloader.font.fonts.DashUnicodeFont;
import net.quantumfusion.dashloader.mixin.NativeImageAccessor;
import net.quantumfusion.dashloader.models.DashModel;
import net.quantumfusion.dashloader.models.DashModelIdentifier;
import net.quantumfusion.dashloader.models.predicates.DashPredicate;
import net.quantumfusion.dashloader.models.predicates.PredicateHelper;
import net.quantumfusion.dashloader.registry.RegistryBlockStateData;
import net.quantumfusion.dashloader.registry.RegistryFontData;
import net.quantumfusion.dashloader.registry.RegistryIdentifierData;
import net.quantumfusion.dashloader.registry.RegistryImageData;
import net.quantumfusion.dashloader.registry.RegistryModelData;
import net.quantumfusion.dashloader.registry.RegistryPredicateData;
import net.quantumfusion.dashloader.registry.RegistryPropertyData;
import net.quantumfusion.dashloader.registry.RegistryPropertyValueData;
import net.quantumfusion.dashloader.registry.RegistrySpriteData;
import net.quantumfusion.dashloader.util.ThreadHelper;
import net.quantumfusion.dashloader.util.UndashTask;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class DashRegistry {
    private static final int totalTasks = 6;
    private static int tasksDone = 0;
    public Map<Class, Integer> modelsFailed = new ConcurrentHashMap<Class, Integer>();
    public Map<Long, class_2680> blockstatesOut;
    public Map<Long, Predicate<class_2680>> predicateOut;
    public Map<Long, class_2960> identifiersOut;
    public Map<Long, class_1087> modelsOut;
    public Map<Long, class_1058> spritesOut;
    public Map<Long, class_390> fontsOut;
    public Map<Long, class_1011> imagesOut;
    public Map<Long, class_2769<?>> propertiesOut;
    public Map<Long, Comparable<?>> propertyValuesOut;
    DashLoader loader;
    private Map<Long, DashBlockState> blockstates;
    private Map<Long, DashSprite> sprites;
    private Map<Long, DashID> identifiers;
    private final Map<Long, DashModel> models;
    private Map<Long, DashFont> fonts;
    private Map<Long, DashImage> images;
    private Map<Long, DashPredicate> predicates;
    private Map<Long, DashProperty> properties;
    private Map<Long, DashPropertyValue> propertyValues;
    private List<Map<Long, DashModel>> modelsToDeserialize;

    public DashRegistry(Map<Long, DashBlockState> blockstates, Map<Long, DashSprite> sprites, Map<Long, DashID> identifiers, Map<Long, DashModel> models, Map<Long, DashFont> fonts, Map<Long, DashImage> images, Map<Long, DashPredicate> predicates, Map<Long, DashProperty> properties, Map<Long, DashPropertyValue> propertyValues) {
        this.blockstates = blockstates;
        this.sprites = sprites;
        this.identifiers = identifiers;
        this.models = models;
        this.fonts = fonts;
        this.images = images;
        this.predicates = predicates;
        this.properties = properties;
        this.propertyValues = propertyValues;
    }

    public DashRegistry(DashLoader loader) {
        this.blockstates = new HashMap<Long, DashBlockState>();
        this.sprites = new HashMap<Long, DashSprite>();
        this.identifiers = new HashMap<Long, DashID>();
        this.models = new HashMap<Long, DashModel>();
        this.fonts = new HashMap<Long, DashFont>();
        this.predicates = new HashMap<Long, DashPredicate>();
        this.images = new HashMap<Long, DashImage>();
        this.properties = new HashMap<Long, DashProperty>();
        this.propertyValues = new HashMap<Long, DashPropertyValue>();
        this.modelsToDeserialize = new ArrayList<Map<Long, DashModel>>();
        this.loader = loader;
    }

    public RegistryBlockStateData getBlockstates() {
        return new RegistryBlockStateData(this.blockstates);
    }

    public void setBlockstates(Map<Long, DashBlockState> blockstates) {
        this.blockstates = blockstates;
    }

    public RegistrySpriteData getSprites() {
        return new RegistrySpriteData(this.sprites);
    }

    public void setSprites(Map<Long, DashSprite> sprites) {
        this.sprites = sprites;
    }

    public RegistryIdentifierData getIdentifiers() {
        return new RegistryIdentifierData(this.identifiers);
    }

    public void setIdentifiers(Map<Long, DashID> identifiers) {
        this.identifiers = identifiers;
    }

    public RegistryModelData getModels() {
        HashMap<Integer, Map> modelsToAdd = new HashMap<Integer, Map>();
        this.models.forEach((aLong, dashModel) -> {
            Map longDashModelMap = (Map)modelsToAdd.get(dashModel.getStage());
            if (longDashModelMap == null) {
                HashMap<Long, DashModel> element = new HashMap<Long, DashModel>();
                element.put((Long)aLong, (DashModel)dashModel);
                modelsToAdd.put(dashModel.getStage(), element);
            } else {
                longDashModelMap.put(aLong, dashModel);
            }
        });
        this.modelsToDeserialize = new ArrayList<Map<Long, DashModel>>();
        modelsToAdd.forEach(this.modelsToDeserialize::add);
        return new RegistryModelData(this.modelsToDeserialize);
    }

    public void setModels(RegistryModelData data) {
        this.modelsToDeserialize = data.models;
    }

    public RegistryFontData getFonts() {
        return new RegistryFontData(this.fonts);
    }

    public void setFonts(Map<Long, DashFont> fonts) {
        this.fonts = fonts;
    }

    public RegistryImageData getImages() {
        return new RegistryImageData(this.images);
    }

    public void setImages(Map<Long, DashImage> images) {
        this.images = images;
    }

    public RegistryPredicateData getPredicates() {
        return new RegistryPredicateData(this.predicates);
    }

    public void setPredicates(Map<Long, DashPredicate> predicates) {
        this.predicates = predicates;
    }

    public RegistryPropertyData getProperties() {
        return new RegistryPropertyData(this.properties);
    }

    public void setProperties(Map<Long, DashProperty> properties) {
        this.properties = properties;
    }

    public Map<Long, DashProperty> getPropertiesRaw() {
        return this.properties;
    }

    public RegistryPropertyValueData getPropertyValues() {
        return new RegistryPropertyValueData(this.propertyValues);
    }

    public void setPropertyValues(Map<Long, DashPropertyValue> propertyValues) {
        this.propertyValues = propertyValues;
    }

    public long createBlockStatePointer(class_2680 blockState) {
        long hash = blockState.hashCode();
        if (this.blockstates.get(hash) == null) {
            this.blockstates.put(hash, new DashBlockState(blockState, this));
        }
        return hash;
    }

    public final <K> Long createModelPointer(class_1087 bakedModel, @Nullable K var) {
        if (bakedModel == null) {
            return null;
        }
        long hash = bakedModel.hashCode();
        if (this.models.get(hash) == null) {
            DashModelFactory model = this.loader.modelMappings.get(bakedModel.getClass());
            if (model != null) {
                this.models.put(hash, model.toDash(bakedModel, this, var));
            } else {
                Integer integer = this.modelsFailed.get(bakedModel.getClass());
                if (integer != null) {
                    integer = integer + 1;
                } else {
                    this.modelsFailed.put(bakedModel.getClass(), 0);
                }
            }
        }
        return hash;
    }

    public final long createSpritePointer(class_1058 sprite) {
        long hash = sprite.hashCode();
        if (this.sprites.get(hash) == null) {
            this.sprites.put(hash, new DashSprite(sprite, this));
        }
        return hash;
    }

    public final long createIdentifierPointer(class_2960 identifier) {
        long hash = identifier.hashCode();
        if (this.identifiers.get(hash) == null) {
            if (identifier instanceof class_1091) {
                this.identifiers.put(hash, new DashModelIdentifier((class_1091)identifier));
            } else {
                this.identifiers.put(hash, new DashIdentifier(identifier));
            }
        }
        return hash;
    }

    public final long createImagePointer(class_1011 image) {
        long hash = ((NativeImageAccessor)image).getPointer();
        if (this.images.get(hash) == null) {
            this.images.put(hash, new DashImage(image));
        }
        return hash;
    }

    public final long createPredicatePointer(class_815 selector, class_2689<class_2248, class_2680> stateManager) {
        long hash = selector.hashCode();
        if (this.predicates.get(hash) == null) {
            this.predicates.put(hash, (DashPredicate)PredicateHelper.getPredicate(selector, stateManager, this));
        }
        return hash;
    }

    public final long createFontPointer(class_390 font) {
        long hash = font.hashCode();
        if (this.fonts.get(hash) == null) {
            if (font instanceof class_386) {
                this.fonts.put(hash, new DashBitmapFont((class_386)font, this));
            } else if (font instanceof class_391) {
                this.fonts.put(hash, new DashUnicodeFont((class_391)font, this));
            } else if (font instanceof class_376) {
                this.fonts.put(hash, new DashBlankFont());
            } else {
                DashLoader.LOGGER.warn(font.getClass().getName() + " is not a supported font format, please contact mod developer to add support.");
            }
        }
        return hash;
    }

    public final Pair<Long, Long> createPropertyPointer(class_2769<?> property, Comparable<?> value) {
        boolean prop;
        long hashV = value.hashCode();
        long hashP = property.hashCode();
        boolean propVal = !this.propertyValues.containsKey(hashV);
        boolean bl = prop = !this.properties.containsKey(hashP);
        if (propVal || prop) {
            DashPropertyFactory factory = this.loader.propertyMappings.get(property.getClass());
            if (factory != null) {
                if (prop) {
                    this.properties.put(hashP, factory.toDash(property, this, hashP));
                }
                if (propVal) {
                    this.propertyValues.put(hashV, factory.toDash(value, this, hashP));
                }
            } else {
                DashLoader.LOGGER.warn(property.getClass().getName() + " is not a supported property format, please contact mod developer to add support.");
            }
        }
        return Pair.of((Object)hashP, (Object)hashV);
    }

    public final class_2680 getBlockstate(Long pointer) {
        class_2680 blockstate = this.blockstatesOut.get(pointer);
        if (blockstate == null) {
            DashLoader.LOGGER.error("Blockstate not found in data. PINTR: " + pointer);
        }
        return blockstate;
    }

    public final class_1058 getSprite(Long pointer) {
        class_1058 sprite = this.spritesOut.get(pointer);
        if (sprite == null) {
            DashLoader.LOGGER.error("Sprite not found in data. PINTR: " + pointer);
        }
        return sprite;
    }

    public final class_2960 getIdentifier(Long pointer) {
        class_2960 identifier = this.identifiersOut.get(pointer);
        if (identifier == null) {
            DashLoader.LOGGER.error("Identifier not found in data. PINTR: " + pointer);
        }
        return identifier;
    }

    public final class_1087 getModel(Long pointer) {
        class_1087 bakedModel = this.modelsOut.get(pointer);
        if (bakedModel == null) {
            DashLoader.LOGGER.error("Model not found in data. PINTR: " + pointer);
        }
        return bakedModel;
    }

    public final class_390 getFont(Long pointer) {
        class_390 font = this.fontsOut.get(pointer);
        if (font == null) {
            DashLoader.LOGGER.error("Font not found in data. PINTR: " + pointer);
        }
        return font;
    }

    public final class_1011 getImage(Long pointer) {
        class_1011 image = this.imagesOut.get(pointer);
        if (image == null) {
            DashLoader.LOGGER.error("NativeImage not found in data. PINTR: " + pointer);
        }
        return image;
    }

    public final Predicate<class_2680> getPredicate(Long pointer) {
        Predicate<class_2680> predicate = this.predicateOut.get(pointer);
        if (predicate == null) {
            DashLoader.LOGGER.error("Predicate not found in data. PINTR: " + pointer);
        }
        return this.predicateOut.get(pointer);
    }

    public final Pair<class_2769<?>, Comparable<?>> getProperty(Long propertyPointer, Long valuePointer) {
        class_2769<?> property = this.propertiesOut.get(propertyPointer);
        Comparable<?> value = this.propertyValuesOut.get(valuePointer);
        if (property == null && value == null) {
            DashLoader.LOGGER.error("Property not found in data. PINTR: " + propertyPointer + "/" + valuePointer);
        }
        return Pair.of(property, value);
    }

    public void toUndash() {
        Logger logger = LogManager.getLogger();
        this.log(logger, "Loading Simple Objects");
        this.identifiersOut = ThreadHelper.execParallel(this.identifiers, this);
        this.identifiers = null;
        this.imagesOut = ThreadHelper.execParallel(this.images, this);
        this.images = null;
        this.propertiesOut = ThreadHelper.execParallel(this.properties, this);
        this.propertyValuesOut = ThreadHelper.execParallel(this.propertyValues, this);
        this.properties = null;
        this.propertyValues = null;
        this.log(logger, "Loading Advanced Objects");
        this.blockstatesOut = ThreadHelper.execParallel(this.blockstates, this);
        this.blockstates = null;
        this.predicateOut = ThreadHelper.execParallel(this.predicates, this);
        this.predicates = null;
        this.spritesOut = ThreadHelper.execParallel(this.sprites, this);
        this.sprites = null;
        this.fontsOut = ThreadHelper.execParallel(this.fonts, this);
        this.fonts = null;
        this.modelsOut = new ConcurrentHashMap<Long, class_1087>(this.models.size());
        short[] currentStage = new short[]{0};
        this.modelsToDeserialize.forEach(modelCategory -> {
            this.log(logger, "[" + currentStage[0] + "] Loading " + modelCategory.size() + " Models");
            this.modelsOut.putAll(ThreadHelper.execParallel(modelCategory, this));
            currentStage[0] = (short)(currentStage[0] + 1);
        });
        this.log(logger, "Applying Model Overrides");
        this.modelsToDeserialize.forEach(modelcategory -> DashLoader.THREADPOOL.invoke(new UndashTask.ApplyTask(new ArrayList<DashModel>(modelcategory.values()), 100, this)));
        this.modelsToDeserialize = null;
    }

    private void log(Logger logger, String s) {
        logger.info("[" + ++tasksDone + "/" + 6 + "] " + s);
    }
}

