/*
 * Decompiled with CFR 0.152.
 */
package net.quantumfusion.dashloader.atlas;

import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import io.activej.serializer.annotations.SerializeNullable;
import io.activej.serializer.annotations.SerializeNullableEx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.gudenau.lib.unsafe.Unsafe;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.quantumfusion.dashloader.DashLoader;
import net.quantumfusion.dashloader.DashRegistry;
import net.quantumfusion.dashloader.atlas.DashSpriteAtlasTextureData;
import net.quantumfusion.dashloader.mixin.AbstractTextureAccessor;
import net.quantumfusion.dashloader.mixin.SpriteAccessor;
import net.quantumfusion.dashloader.mixin.SpriteAtlasTextureAccessor;

public class DashSpriteAtlasTexture {
    @Serialize(order=0)
    public List<Long> animatedSprites;
    @Serialize(order=1)
    @SerializeNullableEx(value={@SerializeNullable, @SerializeNullable(path={1}), @SerializeNullable(path={0})})
    public Map<Long, Long> sprites;
    @Serialize(order=2)
    public final Long id;
    @Serialize(order=3)
    public final int maxTextureSize;
    @Serialize(order=4)
    public boolean bilinear;
    @Serialize(order=5)
    public boolean mipmap;
    @Serialize(order=6)
    public DashSpriteAtlasTextureData data;

    public DashSpriteAtlasTexture(@Deserialize(value="animatedSprites") List<Long> animatedSprites, @Deserialize(value="sprites") Map<Long, Long> sprites, @Deserialize(value="id") Long id, @Deserialize(value="maxTextureSize") int maxTextureSize, @Deserialize(value="bilinear") boolean bilinear, @Deserialize(value="mipmap") boolean mipmap, @Deserialize(value="data") DashSpriteAtlasTextureData data) {
        this.animatedSprites = animatedSprites;
        this.sprites = sprites;
        this.id = id;
        this.maxTextureSize = maxTextureSize;
        this.bilinear = bilinear;
        this.mipmap = mipmap;
        this.data = data;
    }

    public DashSpriteAtlasTexture(class_1059 spriteAtlasTexture, DashSpriteAtlasTextureData data, DashRegistry registry) {
        SpriteAtlasTextureAccessor spriteTextureAccess = (SpriteAtlasTextureAccessor)spriteAtlasTexture;
        this.data = data;
        this.animatedSprites = new ArrayList<Long>();
        this.sprites = new HashMap<Long, Long>();
        spriteTextureAccess.getAnimatedSprites().forEach(sprite -> this.animatedSprites.add(registry.createSpritePointer((class_1058)sprite)));
        spriteTextureAccess.getSprites().forEach((identifier, sprite) -> this.sprites.put(registry.createIdentifierPointer((class_2960)identifier), registry.createSpritePointer((class_1058)sprite)));
        this.id = registry.createIdentifierPointer(spriteAtlasTexture.method_24106());
        this.maxTextureSize = spriteTextureAccess.getMaxTextureSize();
        this.bilinear = ((AbstractTextureAccessor)spriteAtlasTexture).getBilinear();
        this.mipmap = ((AbstractTextureAccessor)spriteAtlasTexture).getMipmap();
    }

    public class_1059 toUndash(DashRegistry registry) {
        class_1059 spriteAtlasTexture = (class_1059)Unsafe.allocateInstance(class_1059.class);
        AbstractTextureAccessor access = (AbstractTextureAccessor)spriteAtlasTexture;
        access.setBilinear(this.bilinear);
        access.setMipmap(this.mipmap);
        SpriteAtlasTextureAccessor spriteAtlasTextureAccessor = (SpriteAtlasTextureAccessor)spriteAtlasTexture;
        HashMap<class_2960, class_1058> out = new HashMap<class_2960, class_1058>();
        this.sprites.forEach((dashIdentifier, spritePointer) -> out.put(registry.getIdentifier((Long)dashIdentifier), this.loadSprite((Long)spritePointer, registry, spriteAtlasTexture)));
        HashSet<class_2960> outLoad = new HashSet<class_2960>();
        ArrayList<class_1058> outAnimatedSprites = new ArrayList<class_1058>();
        this.animatedSprites.forEach(spritePointer -> outAnimatedSprites.add(this.loadSprite((Long)spritePointer, registry, spriteAtlasTexture)));
        spriteAtlasTextureAccessor.setAnimatedSprites(outAnimatedSprites);
        spriteAtlasTextureAccessor.setSpritesToLoad(outLoad);
        spriteAtlasTextureAccessor.setSprites(out);
        spriteAtlasTextureAccessor.setId(registry.getIdentifier(this.id));
        spriteAtlasTextureAccessor.setMaxTextureSize(this.maxTextureSize);
        DashLoader.getInstance().atlasData.put(spriteAtlasTexture, this.data);
        return spriteAtlasTexture;
    }

    private class_1058 loadSprite(Long spritePointer, DashRegistry registry, class_1059 spriteAtlasTexture) {
        class_1058 sprite = registry.getSprite(spritePointer);
        ((SpriteAccessor)sprite).setAtlas(spriteAtlasTexture);
        return sprite;
    }
}

