/*
 * Decompiled with CFR 0.152.
 */
package net.quantumfusion.dashloader.misc;

import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.quantumfusion.dashloader.util.ReloadEnum;

public class DashMetadata {
    @Serialize(order=0)
    public long modInfo;
    @Serialize(order=1)
    public double dashFormatVersion;

    public DashMetadata(@Deserialize(value="modInfo") long modInfo, @Deserialize(value="dashFormatVersion") double dashFormatVersion) {
        this.modInfo = modInfo;
        this.dashFormatVersion = dashFormatVersion;
    }

    public static DashMetadata create() {
        long out = 420L;
        for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
            if (modContainer.getMetadata().getId().equals("dashloader")) continue;
            ModMetadata metadata = modContainer.getMetadata();
            out += metadata.getVersion().getFriendlyString().chars().asLongStream().sum();
        }
        return new DashMetadata((out ^ 0xFFFFFFFFFFFFFFFFL) + 105L, 0.8);
    }

    public ReloadEnum getState(DashMetadata old) {
        return this.modInfo != old.modInfo ? ReloadEnum.MOD_CHANGE : (this.dashFormatVersion != old.dashFormatVersion ? ReloadEnum.FORMAT_CHANGE : ReloadEnum.ACCEPT);
    }
}

