/*
 * Decompiled with CFR 0.152.
 */
package net.quantumfusion.dashloader.models;

import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import io.activej.serializer.annotations.SerializeNullable;
import io.activej.serializer.annotations.SerializeNullableEx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1093;
import net.minecraft.class_2350;
import net.minecraft.class_777;
import net.quantumfusion.dashloader.DashRegistry;
import net.quantumfusion.dashloader.common.DashDirection;
import net.quantumfusion.dashloader.mixin.BasicBakedModelAccessor;
import net.quantumfusion.dashloader.models.DashModel;
import net.quantumfusion.dashloader.models.components.DashBakedQuad;
import net.quantumfusion.dashloader.models.components.DashModelOverrideList;
import net.quantumfusion.dashloader.models.components.DashModelTransformation;

public class DashBasicBakedModel
implements DashModel {
    @Serialize(order=0)
    public List<DashBakedQuad> quads;
    @Serialize(order=1)
    @SerializeNullableEx(value={@SerializeNullable, @SerializeNullable(path={0}), @SerializeNullable(path={1})})
    public Map<DashDirection, List<DashBakedQuad>> faceQuads;
    @Serialize(order=2)
    public boolean usesAo;
    @Serialize(order=3)
    public boolean hasDepth;
    @Serialize(order=4)
    public boolean isSideLit;
    @Serialize(order=5)
    public DashModelTransformation transformation;
    @Serialize(order=6)
    public DashModelOverrideList itemPropertyOverrides;
    @Serialize(order=7)
    public Long spritePointer;

    public DashBasicBakedModel() {
    }

    public DashBasicBakedModel(@Deserialize(value="quads") List<DashBakedQuad> quads, @Deserialize(value="faceQuads") Map<DashDirection, List<DashBakedQuad>> faceQuads, @Deserialize(value="usesAo") boolean usesAo, @Deserialize(value="hasDepth") boolean hasDepth, @Deserialize(value="isSideLit") boolean isSideLit, @Deserialize(value="transformation") DashModelTransformation transformation, @Deserialize(value="itemPropertyOverrides") DashModelOverrideList itemPropertyOverrides, @Deserialize(value="spritePointer") Long spritePointer) {
        this.quads = quads;
        this.faceQuads = faceQuads;
        this.usesAo = usesAo;
        this.hasDepth = hasDepth;
        this.isSideLit = isSideLit;
        this.transformation = transformation;
        this.itemPropertyOverrides = itemPropertyOverrides;
        this.spritePointer = spritePointer;
    }

    public DashBasicBakedModel(class_1093 basicBakedModel, DashRegistry registry) {
        BasicBakedModelAccessor access = (BasicBakedModelAccessor)basicBakedModel;
        this.quads = new ArrayList<DashBakedQuad>();
        this.faceQuads = new HashMap<DashDirection, List<DashBakedQuad>>();
        access.getQuads().forEach(bakedQuad -> this.quads.add(new DashBakedQuad((class_777)bakedQuad)));
        access.getFaceQuads().forEach((direction, bakedQuads) -> {
            ArrayList out = new ArrayList();
            bakedQuads.forEach(bakedQuad -> out.add(new DashBakedQuad((class_777)bakedQuad)));
            this.faceQuads.put(new DashDirection((class_2350)direction), out);
        });
        this.itemPropertyOverrides = new DashModelOverrideList(access.getItemPropertyOverrides(), registry);
        this.usesAo = access.getUsesAo();
        this.hasDepth = access.getHasDepth();
        this.isSideLit = access.getIsSideLit();
        this.transformation = new DashModelTransformation(access.getTransformation());
        this.spritePointer = registry.createSpritePointer(access.getSprite());
    }

    @Override
    public class_1087 toUndash(DashRegistry registry) {
        class_1058 sprite = registry.getSprite(this.spritePointer);
        ArrayList quadsOut = new ArrayList();
        HashMap faceQuadsOut = new HashMap();
        this.quads.forEach(dashBakedQuad -> quadsOut.add(dashBakedQuad.toUndash(sprite, registry)));
        this.faceQuads.forEach((dashDirection, dashBakedQuads) -> {
            ArrayList out = new ArrayList();
            dashBakedQuads.forEach(dashBakedQuad -> out.add(dashBakedQuad.toUndash(sprite, registry)));
            faceQuadsOut.put(dashDirection.toUndash(registry), out);
        });
        return new class_1093(quadsOut, faceQuadsOut, this.usesAo, this.isSideLit, this.hasDepth, sprite, this.transformation.toUndash(), this.itemPropertyOverrides.toUndash(registry));
    }

    @Override
    public void apply(DashRegistry registry) {
        this.itemPropertyOverrides.applyOverrides(registry);
    }

    @Override
    public int getStage() {
        return 0;
    }
}

