/*
 * Decompiled with CFR 0.152.
 */
package net.quantumfusion.dashloader.models;

import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import io.activej.serializer.annotations.SerializeNullable;
import io.activej.serializer.annotations.SerializeNullableEx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1087;
import net.minecraft.class_1095;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_815;
import net.quantumfusion.dashloader.DashLoader;
import net.quantumfusion.dashloader.DashRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class DashModelData {
    @Serialize(order=0)
    @SerializeNullableEx(value={@SerializeNullable(path={0}), @SerializeNullable(path={1})})
    public Map<Long, Long> models;

    public DashModelData(@Deserialize(value="models") Map<Long, Long> models) {
        this.models = models;
    }

    public DashModelData(Map<class_2960, class_1087> models, Map<class_1095, Pair<List<class_815>, class_2689<class_2248, class_2680>>> multipartData, DashRegistry registry) {
        this.models = new HashMap<Long, Long>();
        models.forEach((identifier, bakedModel) -> {
            if (bakedModel != null) {
                this.models.put(registry.createIdentifierPointer((class_2960)identifier), registry.createModelPointer((class_1087)bakedModel, multipartData.get(bakedModel)));
            }
        });
        ArrayList unsupportedModels = new ArrayList();
        registry.modelsFailed.forEach((aClass, integer) -> unsupportedModels.add(aClass.getName()));
        unsupportedModels.stream().sorted().collect(Collectors.toList()).forEach(s -> DashLoader.LOGGER.warn("Model unsupported: " + s));
        if (!registry.modelsFailed.isEmpty()) {
            DashLoader.LOGGER.warn("Models failed: " + registry.modelsFailed.size());
        }
    }

    public Map<class_2960, class_1087> toUndash(DashRegistry registry) {
        HashMap<class_2960, class_1087> out = new HashMap<class_2960, class_1087>();
        this.models.forEach((identifier, bakedModel) -> out.put(registry.getIdentifier((Long)identifier), registry.getModel((Long)bakedModel)));
        return out;
    }
}

