/*
 * Decompiled with CFR 0.152.
 */
package com.teamfractal.fracdustry.common.block.impl.connectivities;

import com.google.common.collect.Maps;
import com.teamfractal.fracdustry.common.block.init.FDBlocks;
import com.teamfractal.fracdustry.common.blockentity.Connectivities.FDCableBlockEntity;
import com.teamfractal.fracdustry.common.util.energynetwork.EnergyNetwork;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FDCableBlock
extends Block
implements EntityBlock {
    public static final Map<Direction, BooleanProperty> PROPERTY_MAP;

    public FDCableBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76272_).m_60978_(2.0f).m_155956_(2.0f).m_60918_(SoundType.f_56745_));
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_((Property[])PROPERTY_MAP.values().toArray(new BooleanProperty[0]));
        super.m_7926_(builder);
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    }

    @Nonnull
    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return Shapes.m_83040_();
    }

    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter reader, List<Component> list, @Nonnull TooltipFlag flags) {
        list.add((Component)new TranslatableComponent("tooltips.fracdustry.energy_cable").m_130940_(ChatFormatting.DARK_GRAY));
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        for (Direction facing : Direction.values()) {
            Level world = context.m_43725_();
            BlockPos facingPos = context.m_8083_().m_141952_(facing.m_122436_());
            BlockState facingState = world.m_8055_(facingPos);
            state = (BlockState)state.m_61124_((Property)PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.canConnect((LevelAccessor)world, facing.m_122424_(), facingPos, facingState)));
        }
        return state;
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        return (BlockState)state.m_61124_((Property)PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.canConnect(world, facing.m_122424_(), facingPos, facingState)));
    }

    private boolean canConnect(@Nonnull LevelAccessor world, @Nonnull Direction facing, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        if (!state.m_60734_().equals(FDBlocks.blockCable.get())) {
            BlockEntity tileEntity = world.m_7702_(pos);
            return tileEntity != null && tileEntity.getCapability(CapabilityEnergy.ENERGY, facing).isPresent();
        }
        return true;
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Block fromBlock, @Nonnull BlockPos fromPos, boolean isMoving) {
        BlockEntity tileEntity;
        if (!world.m_5776_() && (tileEntity = world.m_7702_(pos)) instanceof FDCableBlockEntity) {
            EnergyNetwork.Factory.get((LevelAccessor)world).enableBlock(pos, () -> ((BlockEntity)tileEntity).m_6596_());
        }
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new FDCableBlockEntity(pos, state);
    }

    @Nonnull
    public List<ItemStack> m_7381_(@Nonnull BlockState state, @Nonnull LootContext.Builder builder) {
        List dropsOriginal = super.m_7381_(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    static {
        EnumMap map = Maps.newEnumMap(Direction.class);
        map.put(Direction.NORTH, BlockStateProperties.f_61368_);
        map.put(Direction.EAST, BlockStateProperties.f_61369_);
        map.put(Direction.SOUTH, BlockStateProperties.f_61370_);
        map.put(Direction.WEST, BlockStateProperties.f_61371_);
        map.put(Direction.UP, BlockStateProperties.f_61366_);
        map.put(Direction.DOWN, BlockStateProperties.f_61367_);
        PROPERTY_MAP = Collections.unmodifiableMap(map);
    }
}

