/*
 * Decompiled with CFR 0.152.
 */
package com.teamfractal.fracdustry.common.blockentity.Generators;

import com.mojang.datafixers.DSL;
import com.teamfractal.fracdustry.common.block.impl.generators.FDMicrowaveGeneratorBlock;
import com.teamfractal.fracdustry.common.container.Generators.FDMicrowaveGeneratorContainer;
import com.teamfractal.fracdustry.common.container.datasync.SimpleArray;
import com.teamfractal.fracdustry.common.tools.ItemCharge;
import com.teamfractal.fracdustry.common.tools.worldCheck;
import com.teamfractal.fracdustry.common.util.energystorage.FDEnergyStorage;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FDMicrowaveGeneratorBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final String NAME = "fracdustry:microwave_generator";
    @ObjectHolder(value="fracdustry:microwave_generator")
    public static BlockEntityType<FDMicrowaveGeneratorBlockEntity> BLOCK_ENTITY_TYPE;
    private final ItemStackHandler itemHandler = this.createHandler();
    private final FDEnergyStorage energyStorage = this.createEnergy();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    private SimpleArray currentEnergy = new SimpleArray();
    private SimpleArray maxEnergy = new SimpleArray();

    @SubscribeEvent
    public static void onRegisterBlockEntityType(@Nonnull RegistryEvent.Register<BlockEntityType<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_(FDMicrowaveGeneratorBlockEntity::new, (Block[])new Block[]{FDMicrowaveGeneratorBlock.BLOCK}).m_58966_(DSL.remainderType()).setRegistryName(NAME)));
    }

    @Nonnull
    public Component m_5446_() {
        return new TextComponent("");
    }

    public AbstractContainerMenu m_7208_(int windowId, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        if (this.f_58857_ != null) {
            return new FDMicrowaveGeneratorContainer(windowId, this.f_58857_, this.f_58858_, playerInventory, playerEntity, this.currentEnergy, this.maxEnergy);
        }
        return null;
    }

    public void m_7651_() {
        super.m_7651_();
        this.handler.invalidate();
        this.energy.invalidate();
    }

    public void tickServer(BlockState state) {
        boolean canGenerateEnergy;
        boolean bl = canGenerateEnergy = this.f_58857_ != null && worldCheck.isNoBlockAboveAt(this.f_58857_, this.f_58858_.m_7494_());
        if (canGenerateEnergy) {
            this.energyStorage.addEnergy(1);
            this.m_6596_();
        }
        BlockState blockState = null;
        if (this.f_58857_ != null) {
            blockState = this.f_58857_.m_8055_(this.f_58858_);
        }
        if (blockState != null) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(worldCheck.isNoBlockAboveAt(this.f_58857_, this.f_58858_))), 3);
        }
        new ItemCharge(this.energyStorage, this.itemHandler.getStackInSlot(0), this, 100);
        this.sendOutPower();
    }

    private void sendOutPower() {
        AtomicInteger capacity = new AtomicInteger(this.energyStorage.getEnergyStored());
        if (capacity.get() > 0) {
            boolean doContinue;
            Direction direction = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
            BlockEntity te = null;
            if (this.f_58857_ != null && direction == this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)) {
                te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(direction));
            }
            if (te != null && !(doContinue = te.getCapability(CapabilityEnergy.ENERGY, direction.m_122424_()).map(handler -> {
                if (handler.canReceive()) {
                    int received = handler.receiveEnergy(Math.min(capacity.get(), 100), false);
                    capacity.addAndGet(-received);
                    this.energyStorage.consumeEnergy(received);
                    this.m_6596_();
                    return capacity.get() > 0;
                }
                return true;
            }).orElse(true).booleanValue())) {
                return;
            }
        }
        this.currentEnergy.m_8050_(0, this.energyStorage.getEnergyStored());
        this.maxEnergy.m_8050_(0, this.energyStorage.getMaxEnergyStored());
    }

    public FDMicrowaveGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super(BLOCK_ENTITY_TYPE, pos, state);
    }

    @Nonnull
    public CompoundTag save(@Nonnull CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        tag.m_128365_("energy", this.energyStorage.serializeNBT());
        return super.save(tag);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        this.itemHandler.deserializeNBT(tag.m_128469_("inv"));
        this.energyStorage.deserializeNBT(tag.m_128423_("energy"));
        super.m_142466_(tag);
    }

    private FDEnergyStorage createEnergy() {
        return new FDEnergyStorage(10000, 100){

            @Override
            protected void onEnergyChanged() {
                FDMicrowaveGeneratorBlockEntity.this.m_6596_();
            }

            public boolean canExtract() {
                return true;
            }
        };
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                FDMicrowaveGeneratorBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            boolean isValid = side != null && side.m_122434_().m_122479_() && side == this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
            return isValid ? this.energy.cast() : super.getCapability(cap, side);
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }
}

