/*
 * Decompiled with CFR 0.152.
 */
package com.teamfractal.fracdustry.common.blockentity.Generators;

import com.google.common.collect.Queues;
import com.mojang.datafixers.DSL;
import com.teamfractal.fracdustry.common.block.impl.generators.FDSolarGeneratorBlock;
import com.teamfractal.fracdustry.common.container.Generators.FDSolarGeneratorContainer;
import com.teamfractal.fracdustry.common.container.datasync.SimpleArray;
import com.teamfractal.fracdustry.common.sound.FDSounds;
import com.teamfractal.fracdustry.common.tools.ItemCharge;
import com.teamfractal.fracdustry.common.util.energystorage.FDEnergyStorage;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FDSolarGeneratorBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final String NAME = "fracdustry:solar_generator";
    @ObjectHolder(value="fracdustry:solar_generator")
    public static BlockEntityType<FDSolarGeneratorBlockEntity> BLOCK_ENTITY_TYPE;
    private final ItemStackHandler itemHandler = this.createHandler();
    private final FDEnergyStorage energyStorage = this.createEnergy();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    private SimpleArray currentEnergy = new SimpleArray();
    private SimpleArray maxEnergy = new SimpleArray();
    private final Queue<Direction> directionQueue = Queues.newArrayDeque((Iterable)Direction.Plane.HORIZONTAL);

    @SubscribeEvent
    public static void onRegisterBlockEntityType(@Nonnull RegistryEvent.Register<BlockEntityType<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_(FDSolarGeneratorBlockEntity::new, (Block[])new Block[]{FDSolarGeneratorBlock.BLOCK}).m_58966_(DSL.remainderType()).setRegistryName(NAME)));
    }

    @Nonnull
    public Component m_5446_() {
        return new TextComponent("");
    }

    public AbstractContainerMenu m_7208_(int windowId, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        if (this.f_58857_ != null) {
            return new FDSolarGeneratorContainer(windowId, this.f_58857_, this.f_58858_, playerInventory, playerEntity, this.currentEnergy, this.maxEnergy);
        }
        return null;
    }

    public void m_7651_() {
        super.m_7651_();
        this.handler.invalidate();
        this.energy.invalidate();
    }

    public void tickServer(BlockState state) {
        if (this.f_58857_ != null && this.f_58857_.m_6042_().m_63935_()) {
            int light = this.f_58857_.m_45517_(LightLayer.SKY, this.f_58858_.m_7494_()) - this.f_58857_.m_7445_();
            this.energyStorage.addEnergy(Math.max(0, light - 10));
            this.m_6596_();
            if (this.f_58857_.m_46467_() % 20L == 0L && light - 10 > 0) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)FDSounds.solar_generator_loop.get(), SoundSource.BLOCKS, 0.2f, 1.0f);
            }
        }
        BlockState blockState = null;
        if (this.f_58857_ != null) {
            blockState = this.f_58857_.m_8055_(this.f_58858_);
        }
        if (blockState != null) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)), 3);
        }
        new ItemCharge(this.energyStorage, this.itemHandler.getStackInSlot(0), this, 25);
        this.sendOutPower();
    }

    private void sendOutPower() {
        AtomicInteger capacity = new AtomicInteger(this.energyStorage.getEnergyStored());
        if (capacity.get() > 0) {
            for (Direction direction : this.directionQueue) {
                boolean doContinue;
                BlockEntity te = null;
                if (this.f_58857_ != null && direction != this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) && direction != ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_()) {
                    te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(direction));
                }
                if (te == null || (doContinue = te.getCapability(CapabilityEnergy.ENERGY, direction.m_122424_()).map(handler -> {
                    if (handler.canReceive()) {
                        int received = handler.receiveEnergy(Math.min(capacity.get(), 100), false);
                        capacity.addAndGet(-received);
                        this.energyStorage.consumeEnergy(received);
                        this.m_6596_();
                        return capacity.get() > 0;
                    }
                    return true;
                }).orElse(true).booleanValue())) continue;
                return;
            }
        }
        this.currentEnergy.m_8050_(0, this.energyStorage.getEnergyStored());
        this.maxEnergy.m_8050_(0, this.energyStorage.getMaxEnergyStored());
    }

    public FDSolarGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super(BLOCK_ENTITY_TYPE, pos, state);
    }

    @Nonnull
    public CompoundTag save(@Nonnull CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        tag.m_128365_("energy", this.energyStorage.serializeNBT());
        return super.save(tag);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        this.itemHandler.deserializeNBT(tag.m_128469_("inv"));
        this.energyStorage.deserializeNBT(tag.m_128423_("energy"));
        super.m_142466_(tag);
    }

    private FDEnergyStorage createEnergy() {
        return new FDEnergyStorage(2500, 100){

            @Override
            protected void onEnergyChanged() {
                FDSolarGeneratorBlockEntity.this.m_6596_();
            }

            public boolean canExtract() {
                return true;
            }
        };
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                FDSolarGeneratorBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            boolean isValid = side != null && side.m_122434_().m_122479_() && side != this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) && side.m_122424_() != this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
            return isValid ? this.energy.cast() : super.getCapability(cap, side);
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }
}

