/*
 * Decompiled with CFR 0.152.
 */
package com.teamfractal.fracdustry.common.blockentity.Generators;

import com.mojang.datafixers.DSL;
import com.teamfractal.fracdustry.common.block.impl.generators.FDVawtBlock;
import com.teamfractal.fracdustry.common.blockentity.Generators.FDKineticGeneratorBlockEntity;
import com.teamfractal.fracdustry.common.container.datasync.SimpleArray;
import com.teamfractal.fracdustry.common.sound.FDSounds;
import com.teamfractal.fracdustry.common.tools.CalculateWindPower;
import com.teamfractal.fracdustry.common.util.energystorage.FDEnergyStorage;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FDVawtBlockEntity
extends BlockEntity
implements IAnimatable {
    public static final String NAME = "fracdustry:vawt";
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    @ObjectHolder(value="fracdustry:vawt")
    public static BlockEntityType<FDVawtBlockEntity> BLOCK_ENTITY_TYPE;
    private final FDEnergyStorage energyStorage = this.createEnergy();
    private int e;
    private int en = 0;
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    private SimpleArray currentEnergy = new SimpleArray();
    private SimpleArray maxEnergy = new SimpleArray();

    @SubscribeEvent
    public static void onRegisterBlockEntityType(@Nonnull RegistryEvent.Register<BlockEntityType<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_(FDVawtBlockEntity::new, (Block[])new Block[]{FDVawtBlock.BLOCK}).m_58966_(DSL.remainderType()).setRegistryName(NAME)));
    }

    public void m_7651_() {
        super.m_7651_();
        this.energy.invalidate();
    }

    public void tickServer(BlockState state) {
        this.e = this.f_58857_ != null ? CalculateWindPower.calculateVawt(this.f_58857_, this.f_58858_) : 0;
        this.energyStorage.addEnergy(this.e);
        this.en = this.energyStorage.getEnergyStored();
        if ((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61448_) != this.e > 0) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(this.e > 0)), 3);
        }
        this.m_6596_();
        if (this.f_58857_.m_46467_() % 20L == 0L && this.e > 0) {
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)FDSounds.wind_turbine_loop.get(), SoundSource.BLOCKS, 0.2f, 1.0f);
        }
        this.sendOutPower();
    }

    private <E extends BlockEntity> PlayState predicate(AnimationEvent<E> event) {
        event.getController().transitionLengthTicks = 0.0;
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.vawt.spin", Boolean.valueOf(true)));
        return (Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61448_) != false ? PlayState.CONTINUE : PlayState.STOP;
    }

    private void sendOutPower() {
        AtomicInteger capacity = new AtomicInteger(this.energyStorage.getEnergyStored());
        if (capacity.get() > 0) {
            boolean doContinue;
            Direction direction = Direction.DOWN;
            BlockEntity te = null;
            if (this.f_58857_ != null) {
                te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(direction));
            }
            if (te instanceof FDKineticGeneratorBlockEntity && !(doContinue = te.getCapability(CapabilityEnergy.ENERGY, direction.m_122424_()).map(handler -> {
                if (handler.canReceive()) {
                    int received = handler.receiveEnergy(Math.min(capacity.get(), 500), false);
                    capacity.addAndGet(-received);
                    this.energyStorage.consumeEnergy(received);
                    this.en = this.energyStorage.getEnergyStored();
                    this.m_6596_();
                    return capacity.get() > 0;
                }
                return true;
            }).orElse(true).booleanValue())) {
                return;
            }
        }
        this.currentEnergy.m_8050_(0, this.energyStorage.getEnergyStored());
        this.maxEnergy.m_8050_(0, this.energyStorage.getMaxEnergyStored());
    }

    public FDVawtBlockEntity(BlockPos pos, BlockState state) {
        super(BLOCK_ENTITY_TYPE, pos, state);
    }

    @Nonnull
    public CompoundTag save(@Nonnull CompoundTag tag) {
        tag.m_128405_("energy", this.en);
        return super.save(tag);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        this.en = tag.m_128451_("energy");
        super.m_142466_(tag);
    }

    private FDEnergyStorage createEnergy() {
        return new FDEnergyStorage(500, 500){

            @Override
            protected void onEnergyChanged() {
                FDVawtBlockEntity.this.m_6596_();
            }

            public boolean canExtract() {
                return true;
            }

            public boolean canReceive() {
                return false;
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            boolean isValid = side == Direction.DOWN;
            return isValid ? this.energy.cast() : super.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

